/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.MultimapSCI;
import org.infinispan.multimap.impl.MultimapTestUtils;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.data.Person;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistributedMultimapCacheTest")
public class DistributedMultimapCacheTest
extends BaseDistFunctionalTest<String, Collection<Person>> {
    protected Map<Address, MultimapCache<String, Person>> multimapCacheCluster = new HashMap<Address, MultimapCache<String, Person>>();
    protected boolean fromOwner;

    public DistributedMultimapCacheTest fromOwner(boolean fromOwner) {
        this.fromOwner = fromOwner;
        return this;
    }

    protected String[] parameterNames() {
        return (String[])DistributedMultimapCacheTest.concat((Object[])super.parameterNames(), (Object[])new String[]{"fromOwner"});
    }

    protected Object[] parameterValues() {
        return DistributedMultimapCacheTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.fromOwner ? Boolean.TRUE : Boolean.FALSE});
    }

    public Object[] factory() {
        return new Object[]{new DistributedMultimapCacheTest().fromOwner(false).cacheMode(CacheMode.DIST_SYNC).transactional(false), new DistributedMultimapCacheTest().fromOwner(true).cacheMode(CacheMode.DIST_SYNC).transactional(false)};
    }

    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        for (EmbeddedCacheManager cacheManager : this.cacheManagers) {
            MultimapCacheManager multimapCacheManager = EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)cacheManager);
            this.multimapCacheCluster.put(cacheManager.getAddress(), (MultimapCache<String, Person>)multimapCacheManager.get(this.cacheName));
        }
    }

    protected SerializationContextInitializer getSerializationContext() {
        return MultimapSCI.INSTANCE;
    }

    protected void initAndTest() {
        MultimapTestUtils.assertMultimapCacheSize(this.multimapCacheCluster, 0);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.getMultimapCacheMember(), "names", MultimapTestUtils.OIHANA);
        this.assertValuesAndOwnership("names", MultimapTestUtils.OIHANA);
    }

    public void testPut() {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
        this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "", MultimapTestUtils.RAMON);
        this.assertValuesAndOwnership("", MultimapTestUtils.RAMON);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.PEPE);
        this.assertValuesAndOwnership("names", MultimapTestUtils.PEPE);
    }

    public void testPutDuplicates() {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.RAMON);
        this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
        this.assertValuesAndOwnership("names", MultimapTestUtils.RAMON);
        AssertJUnit.assertEquals((int)3, (int)((Long)FunctionalTestUtils.await((CompletableFuture)multimapCache.size())).intValue());
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
        this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
        this.assertValuesAndOwnership("names", MultimapTestUtils.RAMON);
        AssertJUnit.assertEquals((int)3, (int)((Long)FunctionalTestUtils.await((CompletableFuture)multimapCache.size())).intValue());
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
        this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
        this.assertValuesAndOwnership("names", MultimapTestUtils.RAMON);
        AssertJUnit.assertEquals((int)3, (int)((Long)FunctionalTestUtils.await((CompletableFuture)multimapCache.size())).intValue());
    }

    public void testRemoveKey() {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        FunctionalTestUtils.await((CompletableFuture)multimapCache.remove((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
        this.assertRemovedOnAllCaches("names");
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "", MultimapTestUtils.RAMON);
        FunctionalTestUtils.await((CompletableFuture)multimapCache.remove((Object)"").thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return multimapCache.get((Object)"").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
    }

    public void testRemoveKeyValue() {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        FunctionalTestUtils.await((CompletableFuture)multimapCache.remove((Object)"unexistingKey", (Object)MultimapTestUtils.OIHANA).thenAccept(r -> AssertJUnit.assertFalse((boolean)r)));
        this.assertValuesAndOwnership("names", MultimapTestUtils.OIHANA);
        FunctionalTestUtils.await((CompletableFuture)multimapCache.remove((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
        this.assertRemovedOnAllCaches("names");
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "", MultimapTestUtils.RAMON);
        FunctionalTestUtils.await((CompletableFuture)multimapCache.remove((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return multimapCache.get((Object)"").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.PEPE);
        FunctionalTestUtils.await((CompletableFuture)multimapCache.remove((Object)"names", (Object)MultimapTestUtils.PEPE).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
    }

    public void testRemoveWithPredicate() {
        MultimapCache multimapCache = this.getMultimapCacheMember();
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)((CompletableFuture)multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r2 -> multimapCache.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertEquals((int)2, (int)v.size())));
        this.assertValuesAndOwnership("names", MultimapTestUtils.OIHANA);
        this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
        MultimapCache multimapCache2 = this.getMultimapCacheMember("names");
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)multimapCache2.remove((SerializablePredicate & Serializable)o -> o.getName().contains("Ka")).thenCompose(r1 -> multimapCache2.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertEquals((int)2, (int)v.size())));
        this.assertValuesAndOwnership("names", MultimapTestUtils.OIHANA);
        this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)multimapCache.remove((SerializablePredicate & Serializable)o -> o.getName().contains("Ju")).thenCompose(r1 -> multimapCache.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertEquals((int)1, (int)v.size())));
        this.assertValuesAndOwnership("names", MultimapTestUtils.OIHANA);
        this.assertKeyValueNotFoundInAllCaches("names", MultimapTestUtils.JULIEN);
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)multimapCache.remove((SerializablePredicate & Serializable)o -> o.getName().contains("Oi")).thenCompose(r1 -> multimapCache.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty())));
        this.assertRemovedOnAllCaches("names");
    }

    public void testGet() {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember();
        FunctionalTestUtils.await((CompletableFuture)multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.OIHANA))));
        FunctionalTestUtils.await((CompletableFuture)multimapCache.getEntry((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((v.isPresent() && ((String)((CacheEntry)v.get()).getKey()).equals("names") && ((Collection)((CacheEntry)v.get()).getValue()).contains(MultimapTestUtils.OIHANA) ? 1 : 0) != 0)));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)multimapCache.put((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r3 -> multimapCache.get((Object)""))).thenAccept(v -> AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON))));
    }

    public void testGetEmpty() {
        MultimapCache multimapCache = this.getMultimapCacheMember();
        FunctionalTestUtils.await((CompletableFuture)multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty())));
        FunctionalTestUtils.await((CompletableFuture)multimapCache.getEntry((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((!v.isPresent() ? 1 : 0) != 0)));
    }

    public void testGetAndModifyResults() {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Person pepe = new Person("Pepe");
        FunctionalTestUtils.await((CompletableFuture)multimapCache.get((Object)"names").thenAccept(v -> {
            ArrayList<Person> modifiedList = new ArrayList<Person>((Collection<Person>)v);
            modifiedList.add(pepe);
        }));
        this.assertKeyValueNotFoundInAllCaches("names", pepe);
    }

    public void testContainsKey() {
        this.initAndTest();
        this.multimapCacheCluster.values().forEach(mc -> {
            FunctionalTestUtils.await((CompletableFuture)mc.containsKey((Object)"other").thenAccept(containsKey -> AssertJUnit.assertFalse((boolean)containsKey)));
            FunctionalTestUtils.await((CompletableFuture)mc.containsKey((Object)"names").thenAccept(containsKey -> AssertJUnit.assertTrue((boolean)containsKey)));
            FunctionalTestUtils.await((CompletableFuture)mc.containsKey((Object)"").thenAccept(containsKey -> AssertJUnit.assertFalse((boolean)containsKey)));
        });
    }

    public void testContainsValue() {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.PEPE);
        this.multimapCacheCluster.values().forEach(mc -> {
            FunctionalTestUtils.await((CompletableFuture)mc.containsValue((Object)MultimapTestUtils.RAMON).thenAccept(containsValue -> AssertJUnit.assertFalse((boolean)containsValue)));
            FunctionalTestUtils.await((CompletableFuture)mc.containsValue((Object)MultimapTestUtils.OIHANA).thenAccept(containsValue -> AssertJUnit.assertTrue((boolean)containsValue)));
            FunctionalTestUtils.await((CompletableFuture)mc.containsValue((Object)MultimapTestUtils.PEPE).thenAccept(containsValue -> AssertJUnit.assertTrue((boolean)containsValue)));
        });
    }

    public void testContainEntry() {
        this.initAndTest();
        MultimapTestUtils.putValuesOnMultimapCache(this.multimapCacheCluster, "", MultimapTestUtils.PEPE);
        this.multimapCacheCluster.values().forEach(mc -> {
            FunctionalTestUtils.await((CompletableFuture)mc.containsEntry((Object)"names", (Object)MultimapTestUtils.RAMON).thenAccept(containsValue -> AssertJUnit.assertFalse((boolean)containsValue)));
            FunctionalTestUtils.await((CompletableFuture)mc.containsEntry((Object)"names", (Object)MultimapTestUtils.OIHANA).thenAccept(containsValue -> AssertJUnit.assertTrue((boolean)containsValue)));
            FunctionalTestUtils.await((CompletableFuture)mc.containsEntry((Object)"", (Object)MultimapTestUtils.RAMON).thenAccept(containsValue -> AssertJUnit.assertFalse((boolean)containsValue)));
            FunctionalTestUtils.await((CompletableFuture)mc.containsEntry((Object)"", (Object)MultimapTestUtils.PEPE).thenAccept(containsValue -> AssertJUnit.assertTrue((boolean)containsValue)));
        });
    }

    public void testSize() {
        String anotherKey = "firstNames";
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r2 -> multimapCache.put((Object)anotherKey, (Object)MultimapTestUtils.OIHANA))).thenCompose(r3 -> multimapCache.put((Object)anotherKey, (Object)MultimapTestUtils.JULIEN))).thenCompose(r4 -> multimapCache.size())).thenAccept(s -> {
            AssertJUnit.assertEquals((int)4, (int)s.intValue());
            this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
            this.assertValuesAndOwnership("names", MultimapTestUtils.OIHANA);
            this.assertValuesAndOwnership(anotherKey, MultimapTestUtils.JULIEN);
            this.assertValuesAndOwnership(anotherKey, MultimapTestUtils.OIHANA);
        })).thenCompose(r1 -> multimapCache.remove((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r2 -> multimapCache.remove((Object)"names", (Object)MultimapTestUtils.OIHANA))).thenCompose(r2 -> multimapCache.remove((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r3 -> multimapCache.put((Object)anotherKey, (Object)MultimapTestUtils.JULIEN))).thenCompose(r4 -> multimapCache.size())).thenAccept(s -> {
            AssertJUnit.assertEquals((int)2, (int)s.intValue());
            this.assertValuesAndOwnership(anotherKey, MultimapTestUtils.JULIEN);
            this.assertValuesAndOwnership(anotherKey, MultimapTestUtils.OIHANA);
        }));
    }

    public void testGetEntry() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        FunctionalTestUtils.await((CompletableFuture)multimapCache.getEntry((Object)"names").thenAccept(maybeEntry -> AssertJUnit.assertFalse((String)"names", (boolean)maybeEntry.isPresent())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r3 -> multimapCache.getEntry((Object)"names"))).thenAccept(maybeEntry -> AssertJUnit.assertTrue((String)"names", (boolean)maybeEntry.isPresent())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)multimapCache.put((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r3 -> multimapCache.getEntry((Object)""))).thenAccept(v -> AssertJUnit.assertTrue((v.isPresent() && ((String)((CacheEntry)v.get()).getKey()).equals("") && ((Collection)((CacheEntry)v.get()).getValue()).contains(MultimapTestUtils.RAMON) ? 1 : 0) != 0)));
    }

    public void testPutWithNull() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> multimapCache.put((Object)MultimapTestUtils.NULL_KEY, (Object)MultimapTestUtils.OIHANA));
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> multimapCache.put((Object)"names", (Object)MultimapTestUtils.NULL_USER));
    }

    public void testGetWithNull() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> multimapCache.get((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testGetEntryWithNull() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> multimapCache.getEntry((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testRemoveKeyValueWithNull() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> multimapCache.remove((Object)MultimapTestUtils.NULL_KEY, (Object)MultimapTestUtils.RAMON));
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> multimapCache.remove((Object)"names", (Object)MultimapTestUtils.NULL_USER));
    }

    public void testRemoveKeyWithNulll() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> multimapCache.remove((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testRemoveWithNullPredicate() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"predicate can't be null", () -> multimapCache.remove((Predicate)null));
    }

    public void testContainsKeyWithNull() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> multimapCache.containsKey((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testContainsValueWithNull() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> multimapCache.containsValue((Object)MultimapTestUtils.NULL_USER));
    }

    public void testContainsEntryWithNull() {
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> multimapCache.containsEntry((Object)MultimapTestUtils.NULL_KEY, (Object)MultimapTestUtils.OIHANA));
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.NULL_USER));
    }

    protected MultimapCache getMultimapCacheMember() {
        return this.multimapCacheCluster.values().stream().findFirst().orElseThrow(() -> new IllegalStateException("Cluster is empty"));
    }

    protected MultimapCache getMultimapCacheMember(String key) {
        Cache cache = this.fromOwner ? this.getFirstOwner(key) : this.getFirstNonOwner(key);
        return this.multimapCacheCluster.get(cache.getCacheManager().getAddress());
    }

    protected MultimapCache getMultimapCacheFirstOwner(String key) {
        Cache cache = this.getFirstOwner(key);
        return this.multimapCacheCluster.get(cache.getCacheManager().getAddress());
    }

    protected void assertValuesAndOwnership(String key, Person value) {
        this.assertOwnershipAndNonOwnership(key, this.l1CacheEnabled);
        this.assertOnAllCaches(key, value);
    }

    protected void assertKeyValueNotFoundInAllCaches(String key, Person value) {
        for (Map.Entry<Address, MultimapCache<String, Person>> entry : this.multimapCacheCluster.entrySet()) {
            FunctionalTestUtils.await((CompletableFuture)entry.getValue().get((Object)key).thenAccept(v -> {
                AssertJUnit.assertNotNull((String)String.format("values on the key %s must be not null", key), (Object)v);
                AssertJUnit.assertFalse((String)String.format("values on the key '%s' must not contain '%s' on node '%s'", key, value, entry.getKey()), (boolean)v.contains(value));
            }));
        }
    }

    protected void assertKeyValueFoundInOwners(String key, Person value) {
        Cache firstOwner = this.getFirstOwner(key);
        Cache secondNonOwner = this.getSecondNonOwner(key);
        MultimapCache<String, Person> mcFirstOwner = this.multimapCacheCluster.get(firstOwner.getCacheManager().getAddress());
        MultimapCache<String, Person> mcSecondOwner = this.multimapCacheCluster.get(secondNonOwner.getCacheManager().getAddress());
        FunctionalTestUtils.await((CompletableFuture)mcFirstOwner.get((Object)key).thenAccept(v -> AssertJUnit.assertTrue((String)String.format("firstOwner '%s' must contain key '%s' value '%s' pair", firstOwner.getCacheManager().getAddress(), key, value), (boolean)v.contains(value))));
        FunctionalTestUtils.await((CompletableFuture)mcSecondOwner.get((Object)key).thenAccept(v -> AssertJUnit.assertTrue((String)String.format("secondOwner '%s' must contain key '%s' value '%s' pair", secondNonOwner.getCacheManager().getAddress(), key, value), (boolean)v.contains(value))));
    }

    protected void assertOwnershipAndNonOwnership(Object key, boolean allowL1) {
        for (Cache cache : this.caches) {
            Object keyToBeChecked = cache.getAdvancedCache().getKeyDataConversion().toStorage(key);
            DataContainer dc = cache.getAdvancedCache().getDataContainer();
            InternalCacheEntry ice = dc.get(keyToBeChecked);
            if (this.isOwner(cache, keyToBeChecked)) {
                AssertJUnit.assertNotNull((Object)ice);
                AssertJUnit.assertTrue((boolean)(ice instanceof ImmortalCacheEntry));
                continue;
            }
            if (allowL1) {
                AssertJUnit.assertTrue((String)"ice is null or L1Entry", (ice == null || ice.isL1Entry() ? 1 : 0) != 0);
                continue;
            }
            DistributedMultimapCacheTest.eventuallyEquals((String)("Fail on non-owner cache " + this.addressOf(cache) + ": dc.get(" + key + ")"), null, () -> dc.get(keyToBeChecked));
        }
    }

    protected void assertOnAllCaches(Object key, Person value) {
        for (Map.Entry<Address, MultimapCache<String, Person>> entry : this.multimapCacheCluster.entrySet()) {
            FunctionalTestUtils.await((CompletableFuture)entry.getValue().get((Object)((String)key)).thenAccept(v -> {
                AssertJUnit.assertNotNull((String)String.format("values on the key %s must be not null", key), (Object)v);
                AssertJUnit.assertTrue((String)String.format("values on the key '%s' must contain '%s' on node '%s'", key, value, entry.getKey()), (boolean)v.contains(value));
            }));
        }
    }
}

