/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.EmbeddedMultimapCacheTest;
import org.infinispan.multimap.impl.MultimapTestUtils;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="multimap.TxEmbeddedMultimapCacheTest")
public class TxEmbeddedMultimapCacheTest
extends EmbeddedMultimapCacheTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((boolean)false);
        MultimapCacheManager multimapCacheManager = EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)cm);
        multimapCacheManager.defineConfiguration("test", c.build());
        this.multimapCache = multimapCacheManager.get("test");
        return cm;
    }

    public void testSizeInExplicitTx() throws SystemException, NotSupportedException {
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        try {
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN, MultimapTestUtils.OIHANA);
            MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 2);
        }
        finally {
            tm1.rollback();
        }
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
    }

    public void testSizeInExplicitTxWithRemoveNonExistentAndPut() throws SystemException, NotSupportedException {
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        try {
            FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"firstnames"));
            MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "firstnames", MultimapTestUtils.JULIEN, MultimapTestUtils.OIHANA, MultimapTestUtils.RAMON);
            MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 4);
        }
        finally {
            tm1.rollback();
        }
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
    }

    public void testSizeInExplicitTxWithRemoveKeyValue() throws SystemException, NotSupportedException {
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN, MultimapTestUtils.OIHANA);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 2);
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        try {
            FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.JULIEN));
            MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
        }
        finally {
            tm1.rollback();
        }
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 2);
    }

    public void testSizeInExplicitTxWithRemoveExistent() throws SystemException, NotSupportedException {
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        try {
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.OIHANA);
            MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 2);
            FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"names"));
            AssertJUnit.assertTrue((boolean)((Collection)FunctionalTestUtils.await((CompletableFuture)this.multimapCache.get((Object)"names"))).isEmpty());
        }
        finally {
            tm1.rollback();
        }
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
    }

    public void testSizeInExplicitTxWithRemoveWithPredicate() throws SystemException, NotSupportedException {
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN, MultimapTestUtils.OIHANA);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 2);
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        try {
            FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.remove((SerializablePredicate & Serializable)v -> v.getName().contains("Ju")).thenCompose(r1 -> this.multimapCache.get((Object)"names"))).thenAccept(values -> {
                AssertJUnit.assertTrue((boolean)values.contains(MultimapTestUtils.OIHANA));
                AssertJUnit.assertFalse((boolean)values.contains(MultimapTestUtils.JULIEN));
            }));
            MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
        }
        finally {
            tm1.rollback();
        }
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 2);
    }

    public void testSizeInExplicitTxWithRemoveAllWithPredicate() throws SystemException, NotSupportedException {
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN, MultimapTestUtils.OIHANA, MultimapTestUtils.KOLDO);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 3);
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        try {
            SerializablePredicate & Serializable removePredicate = (SerializablePredicate & Serializable)v -> v.getName().contains("ih") || v.getName().contains("ol");
            ((CompletableFuture)this.multimapCache.remove((SerializablePredicate)removePredicate).thenAccept(r -> MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1))).join();
        }
        finally {
            tm1.rollback();
        }
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 3);
    }

    public void testSizeInExplicitTxWithModification() throws SystemException, NotSupportedException {
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 0);
        MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.OIHANA);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        try {
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN);
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "morenames", MultimapTestUtils.RAMON);
            MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 3);
        }
        finally {
            tm1.rollback();
        }
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)this.multimapCache, 1);
    }

    public void testContainsMethodsInExplicitTxWithModification() throws SystemException, NotSupportedException {
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(this.multimapCache);
        tm1.begin();
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsKey((Object)"names").thenAccept(c -> AssertJUnit.assertFalse((boolean)c)));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsValue((Object)MultimapTestUtils.JULIEN).thenAccept(c -> AssertJUnit.assertFalse((boolean)c)));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.JULIEN).thenAccept(c -> AssertJUnit.assertFalse((boolean)c)));
        try {
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)this.multimapCache, "names", MultimapTestUtils.JULIEN);
            FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsKey((Object)"names").thenAccept(c -> AssertJUnit.assertTrue((boolean)c)));
            FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsValue((Object)MultimapTestUtils.JULIEN).thenAccept(c -> AssertJUnit.assertTrue((boolean)c)));
            FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.JULIEN).thenAccept(c -> AssertJUnit.assertTrue((boolean)c)));
        }
        finally {
            tm1.rollback();
        }
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsKey((Object)"names").thenAccept(c -> AssertJUnit.assertFalse((boolean)c)));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsValue((Object)MultimapTestUtils.JULIEN).thenAccept(c -> AssertJUnit.assertFalse((boolean)c)));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.JULIEN).thenAccept(c -> AssertJUnit.assertFalse((boolean)c)));
    }
}

