/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.MultimapSCI;
import org.infinispan.multimap.impl.MultimapTestUtils;
import org.infinispan.multimap.impl.SuperPerson;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="multimap.EmbeddedMultimapCacheTest")
public class EmbeddedMultimapCacheTest
extends SingleCacheManagerTest {
    protected MultimapCache<String, Person> multimapCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)MultimapSCI.INSTANCE);
        cm.defineConfiguration("test", new ConfigurationBuilder().build());
        MultimapCacheManager multimapCacheManager = EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)cm);
        this.multimapCache = multimapCacheManager.get("test");
        cm.getClassAllowList().addClasses(new Class[]{SuperPerson.class});
        return cm;
    }

    public void testSupportsDuplicates() {
        AssertJUnit.assertFalse((boolean)this.multimapCache.supportsDuplicates());
    }

    public void testPut() {
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r1 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA))).thenCompose(r2 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r3 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> {
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.JULIEN));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.JULIEN)).count());
        }));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.get((Object)"names").thenAccept(v -> {
            AssertJUnit.assertFalse((boolean)v.contains(MultimapTestUtils.KOLDO));
            AssertJUnit.assertEquals((int)2, (int)v.size());
        }));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.put((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r1 -> this.multimapCache.get((Object)"").thenAccept(v -> {
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.RAMON)).count());
        })));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.PEPE).thenCompose(r1 -> this.multimapCache.get((Object)"names").thenAccept(v -> {
            AssertJUnit.assertTrue((boolean)v.contains((Object)MultimapTestUtils.PEPE));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.PEPE)).count());
        })));
    }

    public void testPutDuplicates() {
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r1 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.RAMON).thenCompose(r2 -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.get((Object)"names").thenAccept(v -> {
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.JULIEN));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.JULIEN)).count());
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.RAMON)).count());
        })).thenCompose(r3 -> this.multimapCache.size())).thenAccept(v -> AssertJUnit.assertEquals((int)2, (int)v.intValue()))).thenCompose(r4 -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r5 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> {
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.JULIEN));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.JULIEN)).count());
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.RAMON)).count());
        })).thenCompose(r3 -> this.multimapCache.size())).thenAccept(v -> AssertJUnit.assertEquals((int)2, (int)v.intValue()))).thenCompose(r5 -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r6 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> {
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.JULIEN));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.JULIEN)).count());
            AssertJUnit.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON));
            AssertJUnit.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.RAMON)).count());
        })).thenCompose(r7 -> this.multimapCache.size())).thenAccept(v -> AssertJUnit.assertEquals((int)2, (int)v.intValue())))))));
    }

    public void testRemoveKey() {
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> AssertJUnit.assertEquals((int)1, (int)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return this.multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"names").thenAccept(r -> AssertJUnit.assertFalse((boolean)r)));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> AssertJUnit.assertEquals((int)1, (int)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return this.multimapCache.get((Object)"").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
    }

    public void testRemoveKeyValue() {
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> AssertJUnit.assertEquals((int)1, (int)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"unexistingKey", (Object)MultimapTestUtils.OIHANA).thenAccept(r -> AssertJUnit.assertFalse((boolean)r)));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r1 -> {
            AssertJUnit.assertFalse((boolean)r1);
            return this.multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertEquals((int)1, (int)v.size()));
        }));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return this.multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.size().thenAccept(s -> AssertJUnit.assertEquals((int)0, (int)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> AssertJUnit.assertEquals((int)1, (int)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return this.multimapCache.get((Object)"").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.PEPE).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> AssertJUnit.assertEquals((int)1, (int)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.PEPE).thenCompose(r1 -> {
            AssertJUnit.assertTrue((boolean)r1);
            return this.multimapCache.get((Object)"names").thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty()));
        }));
    }

    public void testRemoveWithPredicate() {
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r2 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertEquals((int)2, (int)v.size())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.remove((SerializablePredicate & Serializable)o -> o.getName().contains("Ka")).thenCompose(r1 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertEquals((int)2, (int)v.size())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.remove((SerializablePredicate & Serializable)o -> o.getName().contains("Ju")).thenCompose(r1 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertEquals((int)1, (int)v.size())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.remove((SerializablePredicate & Serializable)o -> o.getName().contains("Oi")).thenCompose(r1 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> AssertJUnit.assertTrue((boolean)v.isEmpty())));
    }

    public void testGetAndModifyResults() {
        Person pepe = new Person("Pepe");
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r1 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA))).thenCompose(r2 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.RAMON))).thenCompose(r3 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> {
            AssertJUnit.assertEquals((int)3, (int)v.size());
            ArrayList<Person> modifiedList = new ArrayList<Person>((Collection<Person>)v);
            modifiedList.add(pepe);
            AssertJUnit.assertEquals((int)3, (int)v.size());
            AssertJUnit.assertEquals((int)4, (int)modifiedList.size());
        }));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.get((Object)"names").thenAccept(v -> {
            AssertJUnit.assertFalse((boolean)v.contains(pepe));
            AssertJUnit.assertEquals((int)3, (int)v.size());
        }));
    }

    public void testSize() {
        String anotherKey = "firstNames";
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r2 -> this.multimapCache.put((Object)anotherKey, (Object)MultimapTestUtils.OIHANA))).thenCompose(r3 -> this.multimapCache.put((Object)anotherKey, (Object)MultimapTestUtils.JULIEN))).thenCompose(r4 -> this.multimapCache.size())).thenAccept(s -> AssertJUnit.assertEquals((int)4, (int)s.intValue()))).thenCompose(r1 -> this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r2 -> this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.OIHANA))).thenCompose(r2 -> this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenCompose(r3 -> this.multimapCache.put((Object)anotherKey, (Object)MultimapTestUtils.JULIEN))).thenCompose(r4 -> this.multimapCache.size())).thenAccept(s -> AssertJUnit.assertEquals((int)2, (int)s.intValue())));
    }

    public void testContainsKey() {
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsKey((Object)"names").thenAccept(containsKey -> AssertJUnit.assertFalse((boolean)containsKey)));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r -> this.multimapCache.containsKey((Object)"names"))).thenAccept(containsKey -> AssertJUnit.assertTrue((boolean)containsKey)));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"", (Object)MultimapTestUtils.KOLDO).thenCompose(r -> this.multimapCache.containsKey((Object)""))).thenAccept(containsKey -> AssertJUnit.assertTrue((boolean)containsKey)));
    }

    public void testContainsValue() {
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsValue((Object)MultimapTestUtils.OIHANA).thenAccept(containsValue -> AssertJUnit.assertFalse((boolean)containsValue)));
        MultimapTestUtils.putValuesOnMultimapCache(this.multimapCache, "names", MultimapTestUtils.OIHANA, MultimapTestUtils.JULIEN, MultimapTestUtils.RAMON, MultimapTestUtils.KOLDO, MultimapTestUtils.PEPE);
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsValue((Object)MultimapTestUtils.RAMON).thenAccept(containsValue -> AssertJUnit.assertTrue((boolean)containsValue)));
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsValue((Object)MultimapTestUtils.PEPE).thenAccept(containsValue -> AssertJUnit.assertTrue((boolean)containsValue)));
    }

    public void testContainEntry() {
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.OIHANA).thenAccept(containsEntry -> AssertJUnit.assertFalse((boolean)containsEntry)));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r -> this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.OIHANA))).thenAccept(containsEntry -> AssertJUnit.assertTrue((boolean)containsEntry)));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r -> this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.JULIEN))).thenAccept(containsEntry -> AssertJUnit.assertFalse((boolean)containsEntry)));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.PEPE).thenCompose(r -> this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.PEPE))).thenAccept(containsEntry -> AssertJUnit.assertTrue((boolean)containsEntry)));
    }

    public void testGetEntry() {
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.getEntry((Object)"names").thenAccept(maybeEntry -> AssertJUnit.assertFalse((String)"names", (boolean)maybeEntry.isPresent())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r3 -> this.multimapCache.getEntry((Object)"names"))).thenAccept(maybeEntry -> {
            AssertJUnit.assertTrue((String)"names", (boolean)maybeEntry.isPresent());
            CacheEntry entry = (CacheEntry)maybeEntry.get();
            AssertJUnit.assertEquals((String)"names", (String)((String)entry.getKey()));
            AssertJUnit.assertTrue((boolean)((Collection)entry.getValue()).contains(MultimapTestUtils.JULIEN));
        }));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"", (Object)MultimapTestUtils.RAMON).thenCompose(r3 -> this.multimapCache.getEntry((Object)""))).thenAccept(v -> AssertJUnit.assertTrue((v.isPresent() && ((String)((CacheEntry)v.get()).getKey()).equals("") && ((Collection)((CacheEntry)v.get()).getValue()).contains(MultimapTestUtils.RAMON) ? 1 : 0) != 0)));
    }

    public void testPutWithNull() {
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> this.multimapCache.put((Object)MultimapTestUtils.NULL_KEY, (Object)MultimapTestUtils.OIHANA));
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.NULL_USER));
    }

    public void testGetWithNull() {
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> this.multimapCache.get((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testGetEntryWithNull() {
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> this.multimapCache.getEntry((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testRemoveKeyValueWithNull() {
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> this.multimapCache.remove((Object)MultimapTestUtils.NULL_KEY, (Object)MultimapTestUtils.RAMON));
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.NULL_USER));
    }

    public void testRemoveKeyWithNulll() {
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> this.multimapCache.remove((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testRemoveWithNullPredicate() {
        Exceptions.expectException(NullPointerException.class, (String)"predicate can't be null", () -> this.multimapCache.remove((Predicate)null));
    }

    public void testContainsKeyWithNull() {
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> this.multimapCache.containsKey((Object)MultimapTestUtils.NULL_KEY));
    }

    public void testContainsValueWithNull() {
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> this.multimapCache.containsValue((Object)MultimapTestUtils.NULL_USER));
    }

    public void testContainsEntryWithNull() {
        Exceptions.expectException(NullPointerException.class, (String)"key can't be null", () -> this.multimapCache.containsEntry((Object)MultimapTestUtils.NULL_KEY, (Object)MultimapTestUtils.OIHANA));
        Exceptions.expectException(NullPointerException.class, (String)"value can't be null", () -> this.multimapCache.containsEntry((Object)"names", (Object)MultimapTestUtils.NULL_USER));
    }
}

