/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5300)
public class Bucket<V> {
    final Collection<V> values;

    public Bucket() {
        this.values = Collections.emptyList();
    }

    public Bucket(V value) {
        this.values = Collections.singletonList(value);
    }

    private Bucket(List<V> values) {
        this.values = values;
    }

    @ProtoFactory
    Bucket(Collection<MarshallableUserObject<V>> wrappedValues) {
        this(wrappedValues.stream().map(MarshallableUserObject::get).collect(Collectors.toList()));
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    Collection<MarshallableUserObject<V>> getWrappedValues() {
        return this.values.stream().map(MarshallableUserObject::new).collect(Collectors.toSet());
    }

    public boolean contains(V value) {
        for (V v : this.values) {
            if (!Objects.deepEquals(v, value)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Bucket<V> add(V value) {
        ArrayList<V> newBucket = new ArrayList<V>(this.values.size() + 1);
        for (V v : this.values) {
            if (Objects.deepEquals(v, value)) {
                return null;
            }
            newBucket.add(v);
        }
        newBucket.add(value);
        return new Bucket(newBucket);
    }

    public Bucket<V> remove(V value) {
        ArrayList<V> newBucket = new ArrayList<V>(this.values.size());
        boolean removed = false;
        Iterator<V> it = this.values.iterator();
        while (it.hasNext()) {
            V v = it.next();
            if (Objects.deepEquals(v, value)) {
                removed = true;
                break;
            }
            newBucket.add(v);
        }
        while (it.hasNext()) {
            newBucket.add(it.next());
        }
        return removed ? new Bucket(newBucket) : null;
    }

    public Bucket<V> removeIf(Predicate<? super V> p) {
        ArrayList<V> newBucket = new ArrayList<V>(this.values.size());
        for (V v : this.values) {
            if (p.test(v)) continue;
            newBucket.add(v);
        }
        return newBucket.size() == this.values.size() ? null : new Bucket(newBucket);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }

    public Set<V> toSet() {
        return new HashSet<V>(this.values);
    }

    public String toString() {
        return "Bucket{values=" + Util.toStr(this.values) + '}';
    }
}

