/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.MultimapSCI;
import org.infinispan.multimap.impl.MultimapTestUtils;
import org.infinispan.multimap.impl.SuperPerson;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="multimap.EmbeddedMultimapCacheWithDuplicatesTest")
public class EmbeddedMultimapCacheWithDuplicatesTest
extends SingleCacheManagerTest {
    private static final String TEST_CACHE_NAME = EmbeddedMultimapCacheWithDuplicatesTest.class.getSimpleName();
    protected MultimapCache<String, Person> multimapCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)MultimapSCI.INSTANCE);
        cm.defineConfiguration(TEST_CACHE_NAME, new ConfigurationBuilder().build());
        MultimapCacheManager multimapCacheManager = EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)cm);
        this.multimapCache = multimapCacheManager.get(TEST_CACHE_NAME, true);
        cm.getClassAllowList().addClasses(new Class[]{SuperPerson.class});
        return cm;
    }

    public void testSupportsDuplicates() {
        Assert.assertTrue((boolean)this.multimapCache.supportsDuplicates());
    }

    public void testPutDuplicates() {
        FunctionalTestUtils.await((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r1 -> this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.RAMON).thenCompose(r2 -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.get((Object)"names").thenAccept(v -> {
            Assert.assertTrue((boolean)v.contains(MultimapTestUtils.JULIEN));
            Assert.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.JULIEN)).count());
            Assert.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON));
            Assert.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.RAMON)).count());
        })).thenCompose(r3 -> this.multimapCache.size())).thenAccept(v -> Assert.assertEquals((long)2L, (long)v.intValue()))).thenCompose(r4 -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r5 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> {
            Assert.assertTrue((boolean)v.contains(MultimapTestUtils.JULIEN));
            Assert.assertEquals((long)2L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.JULIEN)).count());
            Assert.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON));
            Assert.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.RAMON)).count());
        })).thenCompose(r3 -> this.multimapCache.size())).thenAccept(v -> Assert.assertEquals((long)3L, (long)v.intValue()))).thenCompose(r5 -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.JULIEN).thenCompose(r6 -> this.multimapCache.get((Object)"names"))).thenAccept(v -> {
            Assert.assertTrue((boolean)v.contains(MultimapTestUtils.JULIEN));
            Assert.assertEquals((long)3L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.JULIEN)).count());
            Assert.assertTrue((boolean)v.contains(MultimapTestUtils.RAMON));
            Assert.assertEquals((long)1L, (long)v.stream().filter(n -> n.equals((Object)MultimapTestUtils.RAMON)).count());
        })).thenCompose(r7 -> this.multimapCache.size())).thenAccept(v -> Assert.assertEquals((long)4L, (long)v.intValue())))))));
    }

    public void testRemoveKeyValue() {
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> Assert.assertEquals((long)1L, (long)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> Assert.assertEquals((long)2L, (long)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.put((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> Assert.assertEquals((long)3L, (long)s.intValue())));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)this.multimapCache.remove((Object)"names", (Object)MultimapTestUtils.OIHANA).thenCompose(r1 -> this.multimapCache.size())).thenAccept(s -> Assert.assertEquals((long)0L, (long)s.intValue())));
    }
}

