/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.multimap.api.MultimapCache;
import org.infinispan.multimap.impl.DistributedMultimapCacheTest;
import org.infinispan.multimap.impl.MultimapTestUtils;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.data.Person;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.TxDistributedMultimapCacheTest")
public class TxDistributedMultimapCacheTest
extends DistributedMultimapCacheTest {
    public TxDistributedMultimapCacheTest() {
        this.transactional = true;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
        this.cacheMode = CacheMode.DIST_SYNC;
    }

    @Override
    protected String[] parameterNames() {
        return (String[])TxDistributedMultimapCacheTest.concat((Object[])super.parameterNames(), (Object[])new String[]{"fromOwner"});
    }

    @Override
    protected Object[] parameterValues() {
        return TxDistributedMultimapCacheTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.fromOwner ? Boolean.TRUE : Boolean.FALSE});
    }

    @Override
    public Object[] factory() {
        ArrayList testsToRun = new ArrayList();
        testsToRun.addAll(this.txTests(LockingMode.OPTIMISTIC));
        testsToRun.addAll(this.txTests(LockingMode.PESSIMISTIC));
        return testsToRun.toArray();
    }

    public void testExplicitTx() throws SystemException, NotSupportedException {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(multimapCache);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)multimapCache, 1);
        tm1.begin();
        try {
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
            if (this.fromOwner) {
                MultimapTestUtils.assertContaisKeyValue((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
            }
            tm1.commit();
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.getMessage());
        }
        this.assertValuesAndOwnership("names", MultimapTestUtils.JULIEN);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)multimapCache, 2);
    }

    public void testExplicitTxWithRollback() throws SystemException, NotSupportedException {
        this.initAndTest();
        MultimapCache multimapCache = this.getMultimapCacheMember("names");
        TransactionManager tm1 = MultimapTestUtils.getTransactionManager(multimapCache);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)multimapCache, 1);
        tm1.begin();
        try {
            MultimapTestUtils.putValuesOnMultimapCache((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
            if (this.fromOwner) {
                MultimapTestUtils.assertContaisKeyValue((MultimapCache<String, Person>)multimapCache, "names", MultimapTestUtils.JULIEN);
            }
        }
        finally {
            tm1.rollback();
        }
        this.assertKeyValueNotFoundInAllCaches("names", MultimapTestUtils.JULIEN);
        MultimapTestUtils.assertMultimapCacheSize((MultimapCache<String, Person>)multimapCache, 1);
    }

    private List txTests(LockingMode lockingMode) {
        return Arrays.asList(new TxDistributedMultimapCacheTest().fromOwner(false).lockingMode(lockingMode).isolationLevel(IsolationLevel.READ_COMMITTED), new TxDistributedMultimapCacheTest().fromOwner(true).lockingMode(lockingMode).isolationLevel(IsolationLevel.READ_COMMITTED), new TxDistributedMultimapCacheTest().fromOwner(false).lockingMode(lockingMode).isolationLevel(IsolationLevel.REPEATABLE_READ), new TxDistributedMultimapCacheTest().fromOwner(true).lockingMode(lockingMode).isolationLevel(IsolationLevel.REPEATABLE_READ));
    }
}

