/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.multimap.impl.SuperPerson;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Person;
import org.testng.AssertJUnit;

public class MultimapTestUtils {
    public static final String NAMES_KEY = "names";
    public static final String EMPTY_KEY = "";
    public static final String NULL_KEY = null;
    public static final Person JULIEN = new Person("Julien");
    public static final Person OIHANA = new Person("Oihana");
    public static final Person RAMON = new Person("Ramon");
    public static final Person KOLDO = new Person("Koldo");
    public static final SuperPerson PEPE = new SuperPerson("Pepe");
    public static final SuperPerson NULL_USER = null;

    public static TransactionManager getTransactionManager(MultimapCache multimapCache) {
        EmbeddedMultimapCache embeddedMultimapCache = (EmbeddedMultimapCache)multimapCache;
        return embeddedMultimapCache == null ? null : (TransactionManager)TestingUtil.extractComponent((Cache)embeddedMultimapCache.getCache(), TransactionManager.class);
    }

    public static void putValuesOnMultimapCache(MultimapCache<String, Person> multimapCache, String key, Person ... values) {
        for (int i = 0; i < values.length; ++i) {
            FunctionalTestUtils.await((CompletableFuture)multimapCache.put((Object)key, (Object)values[i]));
        }
    }

    public static void putValuesOnMultimapCache(Map<Address, MultimapCache<String, Person>> cluster, String key, Person ... values) {
        for (MultimapCache<String, Person> mc : cluster.values()) {
            MultimapTestUtils.putValuesOnMultimapCache(mc, key, values);
        }
    }

    public static void assertMultimapCacheSize(MultimapCache<String, Person> multimapCache, int expectedSize) {
        AssertJUnit.assertEquals((int)expectedSize, (int)((Long)FunctionalTestUtils.await((CompletableFuture)multimapCache.size())).intValue());
    }

    public static void assertMultimapCacheSize(Map<Address, MultimapCache<String, Person>> cluster, int expectedSize) {
        for (MultimapCache<String, Person> mc : cluster.values()) {
            MultimapTestUtils.assertMultimapCacheSize(mc, expectedSize);
        }
    }

    public static void assertContaisKeyValue(MultimapCache<String, Person> multimapCache, String key, Person value) {
        Address address = ((EmbeddedMultimapCache)multimapCache).getCache().getCacheManager().getAddress();
        FunctionalTestUtils.await((CompletableFuture)multimapCache.get((Object)key).thenAccept(v -> AssertJUnit.assertTrue((String)String.format("get method call : multimap '%s' must contain key '%s' value '%s' pair", address, key, value), (boolean)v.contains(value))));
        FunctionalTestUtils.await((CompletableFuture)multimapCache.containsEntry((Object)key, (Object)value).thenAccept(v -> AssertJUnit.assertTrue((String)String.format("containsEntry method call : multimap '%s' must contain key '%s' value '%s' pair", address, key, value), (boolean)v)));
    }
}

