/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.function.BaseFunction;

public final class RemoveFunction<K, V>
implements BaseFunction<K, V, Boolean> {
    public static final AdvancedExternalizer<RemoveFunction> EXTERNALIZER = new Externalizer();
    private final V value;

    public RemoveFunction() {
        this.value = null;
    }

    public RemoveFunction(V value) {
        this.value = value;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, Collection<V>> entryView) {
        Boolean removed = this.value == null ? this.removeKey(entryView) : this.removeKeyValue(entryView);
        return removed;
    }

    private Boolean removeKeyValue(EntryView.ReadWriteEntryView<K, Collection<V>> entryView) {
        return entryView.find().map(values -> {
            if (values.contains(this.value)) {
                HashSet newValues = new HashSet();
                newValues.addAll(values);
                newValues.remove(this.value);
                if (newValues.isEmpty()) {
                    entryView.remove();
                } else {
                    entryView.set(newValues, new MetaParam.Writable[0]);
                }
                return newValues.size() < values.size();
            }
            return Boolean.FALSE;
        }).orElse(Boolean.FALSE);
    }

    private Boolean removeKey(EntryView.ReadWriteEntryView<K, Collection<V>> entryView) {
        return entryView.find().map(values -> {
            entryView.remove();
            return Boolean.TRUE;
        }).orElse(Boolean.FALSE);
    }

    private static class Externalizer
    implements AdvancedExternalizer<RemoveFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends RemoveFunction>> getTypeClasses() {
            return Collections.singleton(RemoveFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.REMOVE_KEY_VALUE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, RemoveFunction object) throws IOException {
            output.writeObject(object.value);
        }

        public RemoveFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RemoveFunction(input.readObject());
        }
    }
}

