/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cli.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.cli.configuration.CLInterfaceLoaderConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.remote.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testRemoteCacheStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:7.0 http://www.infinispan.org/schemas/infinispan-config-7.0.xsd\"\n      xmlns=\"urn:infinispan:config:7.0\">   <cache-container default-cache=\"default\">\n      <local-cache name=\"default\">\n     <persistence>\n       <cli-loader xmlns=\"urn:infinispan:config:store:cli:7.0\"                   connection=\"jmx://1.2.3.4:4444/MyCacheManager/myCache\">\n       </cli-loader>\n     </persistence>\n   </local-cache></cache-container>\n</infinispan>";
        CLInterfaceLoaderConfiguration store = (CLInterfaceLoaderConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertEquals((String)"jmx://1.2.3.4:4444/MyCacheManager/myCache", (String)store.connectionString());
    }

    private StoreConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        assert (this.cacheManager.getDefaultCacheConfiguration().persistence().stores().size() == 1);
        return (StoreConfiguration)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().get(0);
    }
}

