/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cli;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.cli.configuration.CLInterfaceLoaderConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.cli.CLInterfaceLoaderFunctionalTest")
public class CLInterfaceLoaderFunctionalTest
extends AbstractInfinispanTest {
    static final String SOURCE_CONNECTION_STRING = "jmx://localhost:2626/SourceCacheManager/___defaultcache";

    public void testSequentialGet() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createSourceCacheManager()){

            public void call() {
                Cache sourceCache = this.cm.getCache();
                sourceCache.put((Object)1, (Object)"v1");
                sourceCache.put((Object)2, (Object)"v2");
                sourceCache.put((Object)3, (Object)"v3");
                TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(CLInterfaceLoaderFunctionalTest.this.createTargetCacheManager()){

                    public void call() {
                        Cache targetCache = this.cm.getCache();
                        AssertJUnit.assertEquals((Object)"v1", (Object)targetCache.get((Object)1));
                        AssertJUnit.assertEquals((Object)"v2", (Object)targetCache.get((Object)2));
                        AssertJUnit.assertEquals((Object)"v3", (Object)targetCache.get((Object)3));
                    }
                });
            }
        });
    }

    public void testMultiThreadGet() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createSourceCacheManager()){

            public void call() {
                Cache sourceCache = this.cm.getCache();
                sourceCache.put((Object)1, (Object)"v1");
                sourceCache.put((Object)2, (Object)"v2");
                sourceCache.put((Object)3, (Object)"v3");
                TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(CLInterfaceLoaderFunctionalTest.this.createTargetCacheManager()){

                    public void call() {
                        Cache targetCache = this.cm.getCache();
                        Future f1 = CLInterfaceLoaderFunctionalTest.this.asyncGet((Cache<Integer, String>)targetCache, 1);
                        Future f2 = CLInterfaceLoaderFunctionalTest.this.asyncGet((Cache<Integer, String>)targetCache, 2);
                        Future f3 = CLInterfaceLoaderFunctionalTest.this.asyncGet((Cache<Integer, String>)targetCache, 3);
                        CLInterfaceLoaderFunctionalTest.this.assertFutureEquals("v1", f1);
                        CLInterfaceLoaderFunctionalTest.this.assertFutureEquals("v2", f2);
                        CLInterfaceLoaderFunctionalTest.this.assertFutureEquals("v3", f3);
                    }
                });
            }
        });
    }

    @Test(groups={"unstable"})
    public void testCustomKey() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createSourceCacheManager()){

            public void call() {
                Cache sourceCache = this.cm.getCache();
                final Key k1 = new Key("k1", false);
                final Key k2 = new Key("k2", false);
                final Key k3 = new Key("k3", false);
                sourceCache.put((Object)k1, (Object)1);
                sourceCache.put((Object)k2, (Object)2);
                sourceCache.put((Object)k3, (Object)3);
                TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(CLInterfaceLoaderFunctionalTest.this.createTargetCacheManager()){

                    public void call() {
                        Cache targetCache = this.cm.getCache();
                        AssertJUnit.assertEquals((Object)new Integer(1), (Object)targetCache.get((Object)k1));
                        AssertJUnit.assertEquals((Object)new Integer(2), (Object)targetCache.get((Object)k2));
                        AssertJUnit.assertEquals((Object)new Integer(3), (Object)targetCache.get((Object)k3));
                    }
                });
            }
        });
    }

    public void testCustomValue() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createSourceCacheManager()){

            public void call() {
                Cache sourceCache = this.cm.getCache();
                final Person p1 = new Person("Jose Garza");
                final Person p2 = new Person("Willard Rogers");
                final Person p3 = new Person("B. Cunningham");
                sourceCache.put((Object)1, (Object)p1);
                sourceCache.put((Object)2, (Object)p2);
                sourceCache.put((Object)3, (Object)p3);
                TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(CLInterfaceLoaderFunctionalTest.this.createTargetCacheManager()){

                    public void call() {
                        Cache targetCache = this.cm.getCache();
                        AssertJUnit.assertEquals((Object)p1, (Object)targetCache.get((Object)1));
                        AssertJUnit.assertEquals((Object)p2, (Object)targetCache.get((Object)2));
                        AssertJUnit.assertEquals((Object)p3, (Object)targetCache.get((Object)3));
                    }
                });
            }
        });
    }

    private Future<String> asyncGet(final Cache<Integer, String> targetCache, final Integer key) {
        return this.fork(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return (String)targetCache.get((Object)key);
            }
        });
    }

    private void assertFutureEquals(String expected, Future<String> f) {
        try {
            AssertJUnit.assertEquals((String)expected, (String)f.get());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private EmbeddedCacheManager createSourceCacheManager() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalJmxStatistics().cacheManagerName("SourceCacheManager");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.jmxStatistics().enable();
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)builder);
    }

    private EmbeddedCacheManager createTargetCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((CLInterfaceLoaderConfigurationBuilder)builder.persistence().addStore(CLInterfaceLoaderConfigurationBuilder.class)).connectionString(SOURCE_CONNECTION_STRING);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }
}

