/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cli;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.infinispan.cli.CommandBuffer;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.Command;
import org.infinispan.cli.commands.ProcessedCommand;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.connection.ConnectionFactory;
import org.infinispan.cli.impl.CommandBufferImpl;
import org.infinispan.cli.impl.ContextImpl;
import org.infinispan.cli.io.IOAdapter;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.cli.configuration.CLInterfaceLoaderConfiguration;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=CLInterfaceLoaderConfiguration.class)
public class CLInterfaceLoader<K, V>
implements CacheLoader<K, V> {
    private InitializationContext ctx;
    private Connection connection;
    private CLInterfaceLoaderConfiguration cfg;
    private ObjectMapper jsonMapper = new ObjectMapper().enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.cfg = (CLInterfaceLoaderConfiguration)ctx.getConfiguration();
    }

    public MarshalledEntry<K, V> load(Object key) {
        ProcessedCommand parsed = new ProcessedCommand("get " + key.toString() + ";");
        Context cliCtx = this.createContext();
        Command command = cliCtx.getCommandRegistry().getCommand(parsed.getCommand());
        command.execute(cliCtx, parsed);
        ResponseMatcher.Result result = ((ResponseMatcher)cliCtx.getOutputAdapter()).getResult(Collections.singletonList(parsed));
        if (result.isError) {
            throw new CacheException("Unable to load entry: " + result.result);
        }
        if (result.result.equals("null")) {
            return null;
        }
        Object value = result.result;
        try {
            value = this.jsonMapper.readValue(result.result, Object.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, value, null);
    }

    private Context createContext() {
        ResponseMatcher responseMatcher = new ResponseMatcher();
        ContextImpl cliCtx = new ContextImpl((IOAdapter)responseMatcher, (CommandBuffer)new CommandBufferImpl());
        cliCtx.setConnection(this.connection);
        return cliCtx;
    }

    public boolean contains(Object key) {
        return this.load(key) != null;
    }

    public void start() {
        String serviceUrl = this.cfg.connectionString();
        this.connection = ConnectionFactory.getConnection((String)serviceUrl);
        try {
            this.connection.connect(null);
        }
        catch (Exception e) {
            throw new CacheException("Unable to connect to URL: " + serviceUrl, (Throwable)e);
        }
    }

    public void stop() {
        if (this.connection != null && this.connection.isConnected()) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    private static class ResponseMatcher
    implements IOAdapter {
        private static final Log log = LogFactory.getLog(ResponseMatcher.class);
        ConcurrentMap<List<ProcessedCommand>, Result> results = CollectionFactory.makeConcurrentMap();

        private ResponseMatcher() {
        }

        public boolean isInteractive() {
            return false;
        }

        public void error(String error) {
            log.error((Object)error);
        }

        public void println(String s) {
            log.debug((Object)s);
        }

        public void result(List<ProcessedCommand> commands, String result, boolean isError) {
            this.results.put(commands, new Result().isError(isError).result(result));
        }

        public String readln(String s) throws IOException {
            return null;
        }

        public String secureReadln(String s) throws IOException {
            return null;
        }

        public int getWidth() {
            return 0;
        }

        public void close() throws IOException {
        }

        Result getResult(List<ProcessedCommand> commands) {
            return (Result)this.results.remove(commands);
        }

        static class Result {
            boolean isError;
            String result;

            Result() {
            }

            Result isError(boolean isError) {
                this.isError = isError;
                return this;
            }

            Result result(String result) {
                this.result = result;
                return this;
            }
        }
    }
}

