/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import java.util.List;
import org.infinispan.ppg.generator.GeneratorException;
import org.infinispan.ppg.generator.Grammar;
import org.infinispan.ppg.generator.Machine;
import org.infinispan.ppg.generator.Reference;
import org.infinispan.ppg.generator.Resolvable;
import org.infinispan.ppg.generator.RuleDefinition;

class Constant
implements Resolvable {
    private final String qualifiedName;
    private final String sourceName;
    private final String type;
    final String file;
    final int line;

    public Constant(String qualifiedName, String sourceName, String type, String file, int line) {
        this.qualifiedName = qualifiedName;
        this.sourceName = sourceName;
        this.type = type;
        this.file = file;
        this.line = line;
    }

    @Override
    public String qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    @Override
    public Machine.State addStates(Machine.State prev, Machine.State target, Machine machine, Grammar grammar, List<RuleDefinition> ruleStack, Reference reference) {
        if (reference.params != null) {
            throw new GeneratorException(reference.file + ":" + reference.line + ": Invalid reference to " + this.sourceName + ", constants cannot have parameters!");
        }
        return prev.requireReadByte(this.sourceName(), target);
    }

    @Override
    public String analyzeType(Grammar grammar) {
        return this.type;
    }

    public String toString() {
        return this.file + ":" + this.line + ": " + this.qualifiedName + " -> " + this.sourceName();
    }
}

