/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.DummyQueryFactory;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CreationTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testWithDifferentFactory1() {
        DummyQueryFactory qf1 = new DummyQueryFactory();
        DummyQueryFactory qf2 = new DummyQueryFactory();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("ISPN014809: The given condition was created by another factory");
        qf1.from("MyDummyType").not((FilterConditionContext)qf2.having("attr1").eq((Object)"1"));
    }

    @Test
    public void testWithDifferentFactory2() {
        DummyQueryFactory qf1 = new DummyQueryFactory();
        DummyQueryFactory qf2 = new DummyQueryFactory();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("ISPN014809: The given condition was created by another factory");
        ((FilterConditionContext)qf1.from("MyDummyType").having("attr1").eq((Object)"1")).and((FilterConditionContext)qf2.having("attr2").eq((Object)"2"));
    }

    @Test
    public void testWithDifferentFactory3() {
        DummyQueryFactory qf1 = new DummyQueryFactory();
        DummyQueryFactory qf2 = new DummyQueryFactory();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("ISPN014809: The given condition was created by another factory");
        ((FilterConditionContext)qf1.from("MyDummyType").having("attr1").eq((Object)"1")).or((FilterConditionContext)qf2.having("attr2").eq((Object)"2"));
    }

    @Test
    public void testWithDifferentBuilder1() {
        DummyQueryFactory qf1 = new DummyQueryFactory();
        FilterConditionContext fcc = (FilterConditionContext)qf1.having("attr1").eq((Object)"1");
        Query q1 = qf1.from("MyDummyType").not(fcc).build();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The given condition is already in use by another builder");
        qf1.from("MyDummyType").not(fcc);
    }

    @Test
    public void testWithDifferentBuilder2() {
        DummyQueryFactory qf1 = new DummyQueryFactory();
        FilterConditionContext fcc = (FilterConditionContext)qf1.having("attr1").eq((Object)"1");
        Query q1 = qf1.from("MyDummyType").not(fcc).build();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The given condition is already in use by another builder");
        ((FilterConditionContext)qf1.from("MyDummyType").having("attr1").eq((Object)"1")).and(fcc);
    }

    @Test
    public void testWithDifferentBuilder3() {
        DummyQueryFactory qf1 = new DummyQueryFactory();
        FilterConditionContext fcc = (FilterConditionContext)qf1.having("attr1").eq((Object)"1");
        Query q1 = qf1.from("MyDummyType").not(fcc).build();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The given condition is already in use by another builder");
        ((FilterConditionContext)qf1.from("MyDummyType").having("attr1").eq((Object)"1")).or(fcc);
    }
}

