package org.infinispan.query.dsl.impl.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-03-18T10:31:51-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String argumentCannotBeNull0 = "ISPN014801: Argument cannot be null";
    protected String argumentCannotBeNull0$str() {
        return argumentCannotBeNull0;
    }
    @Override
    public final IllegalArgumentException argumentCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), argumentCannotBeNull0$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String argumentMustBeComparable = "ISPN014802: '%s' must be an instance of java.lang.Comparable";
    protected String argumentMustBeComparable$str() {
        return argumentMustBeComparable;
    }
    @Override
    public final IllegalArgumentException argumentMustBeComparable(final String argName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), argumentMustBeComparable$str(), argName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterNameCannotBeNulOrEmpty = "ISPN014803: Parameter name cannot be null or empty";
    protected String parameterNameCannotBeNulOrEmpty$str() {
        return parameterNameCannotBeNulOrEmpty;
    }
    @Override
    public final IllegalArgumentException parameterNameCannotBeNulOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterNameCannotBeNulOrEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String queryDoesNotHaveParameters = "ISPN014804: Query does not have parameters";
    protected String queryDoesNotHaveParameters$str() {
        return queryDoesNotHaveParameters;
    }
    @Override
    public final IllegalStateException queryDoesNotHaveParameters() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryDoesNotHaveParameters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterNotFound = "ISPN014805: No parameter named '%s' was found";
    protected String parameterNotFound$str() {
        return parameterNotFound;
    }
    @Override
    public final IllegalArgumentException parameterNotFound(final String paramName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterNotFound$str(), paramName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parametersNotFound = "ISPN014806: No parameters named '%s' were found";
    protected String parametersNotFound$str() {
        return parametersNotFound;
    }
    @Override
    public final IllegalArgumentException parametersNotFound(final String unknownParams) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parametersNotFound$str(), unknownParams));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String listOfValuesForInCannotBeNulOrEmpty = "ISPN014807: The list of values for 'in(..)' cannot be null or empty";
    protected String listOfValuesForInCannotBeNulOrEmpty$str() {
        return listOfValuesForInCannotBeNulOrEmpty;
    }
    @Override
    public final IllegalArgumentException listOfValuesForInCannotBeNulOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), listOfValuesForInCannotBeNulOrEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operatorWasAlreadySpecified = "ISPN014808: operator was already specified";
    protected String operatorWasAlreadySpecified$str() {
        return operatorWasAlreadySpecified;
    }
    @Override
    public final IllegalStateException operatorWasAlreadySpecified() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), operatorWasAlreadySpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conditionWasCreatedByAnotherFactory = "ISPN014809: The given condition was created by another factory";
    protected String conditionWasCreatedByAnotherFactory$str() {
        return conditionWasCreatedByAnotherFactory;
    }
    @Override
    public final IllegalArgumentException conditionWasCreatedByAnotherFactory() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), conditionWasCreatedByAnotherFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conditionIsAlreadyInUseByAnotherBuilder = "ISPN014810: The given condition is already in use by another builder";
    protected String conditionIsAlreadyInUseByAnotherBuilder$str() {
        return conditionIsAlreadyInUseByAnotherBuilder;
    }
    @Override
    public final IllegalArgumentException conditionIsAlreadyInUseByAnotherBuilder() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), conditionIsAlreadyInUseByAnotherBuilder$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseOperatorAgain = "ISPN014811: Sentence already started. Cannot use '%s' again.";
    protected String cannotUseOperatorAgain$str() {
        return cannotUseOperatorAgain;
    }
    @Override
    public final IllegalStateException cannotUseOperatorAgain(final String operatorName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotUseOperatorAgain$str(), operatorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String argumentCannotBeNull1 = "ISPN014812: %s cannot be null";
    protected String argumentCannotBeNull1$str() {
        return argumentCannotBeNull1;
    }
    @Override
    public final IllegalArgumentException argumentCannotBeNull(final String argName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), argumentCannotBeNull1$str(), argName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String queryAlreadyBelongsToAnotherBuilder = "ISPN014813: This query already belongs to another query builder";
    protected String queryAlreadyBelongsToAnotherBuilder$str() {
        return queryAlreadyBelongsToAnotherBuilder;
    }
    @Override
    public final IllegalStateException queryAlreadyBelongsToAnotherBuilder() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryAlreadyBelongsToAnotherBuilder$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String subQueryDoesNotBelongToAParentQueryBuilder = "ISPN014814: This sub-query does not belong to a parent query builder yet";
    protected String subQueryDoesNotBelongToAParentQueryBuilder$str() {
        return subQueryDoesNotBelongToAParentQueryBuilder;
    }
    @Override
    public final IllegalStateException subQueryDoesNotBelongToAParentQueryBuilder() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), subQueryDoesNotBelongToAParentQueryBuilder$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupingCannotBeNullOrEmpty = "ISPN014815: Grouping cannot be null or empty";
    protected String groupingCannotBeNullOrEmpty$str() {
        return groupingCannotBeNullOrEmpty;
    }
    @Override
    public final IllegalArgumentException groupingCannotBeNullOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), groupingCannotBeNullOrEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupingCanBeSpecifiedOnlyOnce = "ISPN014816: Grouping can be specified only once";
    protected String groupingCanBeSpecifiedOnlyOnce$str() {
        return groupingCanBeSpecifiedOnlyOnce;
    }
    @Override
    public final IllegalStateException groupingCanBeSpecifiedOnlyOnce() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), groupingCanBeSpecifiedOnlyOnce$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectingCollectionOrArray = "ISPN014817: Expecting a java.lang.Collection or an array of java.lang.Object";
    protected String expectingCollectionOrArray$str() {
        return expectingCollectionOrArray;
    }
    @Override
    public final IllegalArgumentException expectingCollectionOrArray() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expectingCollectionOrArray$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteSentence = "ISPN014818: Incomplete sentence. Missing attribute path or operator.";
    protected String incompleteSentence$str() {
        return incompleteSentence;
    }
    @Override
    public final IllegalStateException incompleteSentence() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), incompleteSentence$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteCondition = "ISPN014819: Cannot visit an incomplete condition.";
    protected String incompleteCondition$str() {
        return incompleteCondition;
    }
    @Override
    public final IllegalStateException incompleteCondition() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), incompleteCondition$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conditionNotFoundInParent = "ISPN014820: Old child condition not found in parent condition";
    protected String conditionNotFoundInParent$str() {
        return conditionNotFoundInParent;
    }
    @Override
    public final IllegalStateException conditionNotFoundInParent() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), conditionNotFoundInParent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String projectionCannotBeNullOrEmpty = "ISPN014821: Projection cannot be null or empty";
    protected String projectionCannotBeNullOrEmpty$str() {
        return projectionCannotBeNullOrEmpty;
    }
    @Override
    public final IllegalArgumentException projectionCannotBeNullOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), projectionCannotBeNullOrEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String projectionCanBeSpecifiedOnlyOnce = "ISPN014822: Projection can be specified only once";
    protected String projectionCanBeSpecifiedOnlyOnce$str() {
        return projectionCanBeSpecifiedOnlyOnce;
    }
    @Override
    public final IllegalStateException projectionCanBeSpecifiedOnlyOnce() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), projectionCanBeSpecifiedOnlyOnce$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String maxResultMustBeGreaterThanZero = "ISPN014823: maxResults must be greater than 0";
    protected String maxResultMustBeGreaterThanZero$str() {
        return maxResultMustBeGreaterThanZero;
    }
    @Override
    public final IllegalArgumentException maxResultMustBeGreaterThanZero() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), maxResultMustBeGreaterThanZero$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String startOffsetCannotBeLessThanZero = "ISPN014824: startOffset cannot be less than 0";
    protected String startOffsetCannotBeLessThanZero$str() {
        return startOffsetCannotBeLessThanZero;
    }
    @Override
    public final IllegalArgumentException startOffsetCannotBeLessThanZero() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), startOffsetCannotBeLessThanZero$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String queryParameterNotSet = "ISPN014825: Query parameter '%s' was not set";
    protected String queryParameterNotSet$str() {
        return queryParameterNotSet;
    }
    @Override
    public final IllegalStateException queryParameterNotSet(final String paramName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryParameterNotSet$str(), paramName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String leftAndRightCannotBeTheSame = "ISPN014826: Left and right condition cannot be the same";
    protected String leftAndRightCannotBeTheSame$str() {
        return leftAndRightCannotBeTheSame;
    }
    @Override
    public final IllegalArgumentException leftAndRightCannotBeTheSame() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), leftAndRightCannotBeTheSame$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnPerfSortedNonIndexed(final String query) {
        super.log.logf(FQCN, WARN, null, warnPerfSortedNonIndexed$str(), query);
    }
    private static final String warnPerfSortedNonIndexed = "ISPN014827: Distributed sort not supported for non-indexed query '%s'. Consider using an index for optimal performance.";
    protected String warnPerfSortedNonIndexed$str() {
        return warnPerfSortedNonIndexed;
    }
}
