/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.AndCondition;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.BaseQueryBuilder;
import org.infinispan.query.dsl.impl.BetweenOperator;
import org.infinispan.query.dsl.impl.ContainsAllOperator;
import org.infinispan.query.dsl.impl.ContainsAnyOperator;
import org.infinispan.query.dsl.impl.ContainsOperator;
import org.infinispan.query.dsl.impl.EqOperator;
import org.infinispan.query.dsl.impl.GtOperator;
import org.infinispan.query.dsl.impl.GteOperator;
import org.infinispan.query.dsl.impl.InOperator;
import org.infinispan.query.dsl.impl.IsNullOperator;
import org.infinispan.query.dsl.impl.LikeOperator;
import org.infinispan.query.dsl.impl.LtOperator;
import org.infinispan.query.dsl.impl.LteOperator;
import org.infinispan.query.dsl.impl.NotCondition;
import org.infinispan.query.dsl.impl.OperatorAndArgument;
import org.infinispan.query.dsl.impl.OrCondition;
import org.infinispan.query.dsl.impl.SortCriteria;
import org.infinispan.query.dsl.impl.ValueRange;
import org.infinispan.query.dsl.impl.Visitor;

public class JPAQueryGenerator
implements Visitor<String> {
    private static final TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");
    private static final String alias = "_gen0";
    private DateFormat dateFormat;

    @Override
    public <T extends Query> String visit(BaseQueryBuilder<T> baseQueryBuilder) {
        BaseCondition baseCondition;
        String whereCondition;
        boolean isFirst;
        StringBuilder sb = new StringBuilder();
        if (baseQueryBuilder.getProjection() != null && baseQueryBuilder.getProjection().length != 0) {
            sb.append("SELECT ");
            isFirst = true;
            for (String projection : baseQueryBuilder.getProjection()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(alias).append('.').append(projection);
            }
            sb.append(' ');
        }
        sb.append("FROM ").append(this.renderEntityName(baseQueryBuilder.getRootTypeName())).append(' ').append(alias);
        if (baseQueryBuilder.getFilterCondition() != null && !(whereCondition = (baseCondition = baseQueryBuilder.getFilterCondition().getRoot()).accept(this)).isEmpty()) {
            sb.append(" WHERE ").append(whereCondition);
        }
        if (baseQueryBuilder.getSortCriteria() != null && !baseQueryBuilder.getSortCriteria().isEmpty()) {
            sb.append(" ORDER BY ");
            isFirst = true;
            for (SortCriteria sortCriteria : baseQueryBuilder.getSortCriteria()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(alias).append('.').append(sortCriteria.getAttributePath()).append(' ').append(sortCriteria.getSortOrder().name());
            }
        }
        return sb.toString();
    }

    protected String renderEntityName(String rootType) {
        return rootType;
    }

    protected <E extends Enum<E>> String renderEnum(E argument) {
        return '\'' + argument.name() + '\'';
    }

    protected String renderBoolean(boolean argument) {
        return argument ? "true" : "false";
    }

    @Override
    public String visit(AndCondition booleanCondition) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(booleanCondition.getFirstCondition().accept(this));
        sb.append(") AND ( ");
        sb.append(booleanCondition.getSecondCondition().accept(this));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String visit(OrCondition booleanCondition) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(booleanCondition.getFirstCondition().accept(this));
        sb.append(") OR ( ");
        sb.append(booleanCondition.getSecondCondition().accept(this));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String visit(NotCondition notCondition) {
        StringBuilder sb = new StringBuilder();
        sb.append("NOT (");
        sb.append(notCondition.getFirstCondition().accept(this));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String visit(EqOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "=", "!=").toString();
    }

    @Override
    public String visit(GtOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), ">", "<=").toString();
    }

    @Override
    public String visit(GteOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), ">=", "<").toString();
    }

    @Override
    public String visit(LtOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "<", ">=").toString();
    }

    @Override
    public String visit(LteOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "<=", ">").toString();
    }

    @Override
    public String visit(BetweenOperator operator) {
        StringBuilder sb = new StringBuilder();
        ValueRange range = (ValueRange)operator.getArgument();
        if (!range.isIncludeLower() || !range.isIncludeUpper()) {
            this.appendAttributePath(sb, operator.getAttributeCondition());
            sb.append(operator.getAttributeCondition().isNegated() ? (range.isIncludeLower() ? " < " : " <= ") : (range.isIncludeLower() ? " >= " : " > "));
            this.appendArgument(sb, range.getFrom());
            sb.append(operator.getAttributeCondition().isNegated() ? " OR " : " AND ");
            this.appendAttributePath(sb, operator.getAttributeCondition());
            sb.append(operator.getAttributeCondition().isNegated() ? (range.isIncludeUpper() ? " > " : " >= ") : (range.isIncludeUpper() ? " <= " : " < "));
            this.appendArgument(sb, range.getTo());
        } else {
            if (operator.getAttributeCondition().isNegated()) {
                sb.append("NOT ");
            }
            this.appendAttributePath(sb, operator.getAttributeCondition());
            sb.append(" BETWEEN ");
            this.appendArgument(sb, range.getFrom());
            sb.append(" AND ");
            this.appendArgument(sb, range.getTo());
        }
        return sb.toString();
    }

    @Override
    public String visit(LikeOperator operator) {
        StringBuilder sb = new StringBuilder();
        this.appendAttributePath(sb, operator.getAttributeCondition());
        sb.append(' ');
        if (operator.getAttributeCondition().isNegated()) {
            sb.append("NOT ");
        }
        sb.append("LIKE ");
        this.appendArgument(sb, operator.getArgument());
        return sb.toString();
    }

    @Override
    public String visit(IsNullOperator operator) {
        StringBuilder sb = new StringBuilder();
        this.appendAttributePath(sb, operator.getAttributeCondition());
        sb.append(" IS ");
        if (operator.getAttributeCondition().isNegated()) {
            sb.append("NOT ");
        }
        sb.append("null");
        return sb.toString();
    }

    @Override
    public String visit(InOperator operator) {
        StringBuilder sb = new StringBuilder();
        this.appendAttributePath(sb, operator.getAttributeCondition());
        if (operator.getAttributeCondition().isNegated()) {
            sb.append(" NOT");
        }
        sb.append(" IN ");
        this.appendArgument(sb, operator.getArgument());
        return sb.toString();
    }

    @Override
    public String visit(ContainsOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "=", "!=").toString();
    }

    private StringBuilder appendSingleCondition(StringBuilder sb, AttributeCondition attributeCondition, Object argument, String op, String negativeOp) {
        this.appendAttributePath(sb, attributeCondition);
        sb.append(' ');
        sb.append(attributeCondition.isNegated() ? negativeOp : op);
        sb.append(' ');
        this.appendArgument(sb, argument);
        return sb;
    }

    @Override
    public String visit(ContainsAllOperator operator) {
        return this.generateMultipleCondition(operator, "AND");
    }

    @Override
    public String visit(ContainsAnyOperator operator) {
        return this.generateMultipleCondition(operator, "OR");
    }

    private String generateMultipleCondition(OperatorAndArgument operator, String booleanOperator) {
        List<Object> values;
        Object argument = operator.getArgument();
        if (argument instanceof Collection) {
            values = (List<Object>)argument;
        } else if (argument instanceof Object[]) {
            values = Arrays.asList((Object[])argument);
        } else {
            throw new IllegalArgumentException("Expecting a Collection or an array of Object");
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object e : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(' ').append(booleanOperator).append(' ');
            }
            this.appendSingleCondition(sb, operator.getAttributeCondition(), e, "=", "!=");
        }
        return sb.toString();
    }

    @Override
    public String visit(AttributeCondition attributeCondition) {
        if (attributeCondition.getAttributePath() == null || attributeCondition.getOperatorAndArgument() == null) {
            throw new IllegalStateException("Incomplete sentence. Missing attribute path or operator.");
        }
        return attributeCondition.getOperatorAndArgument().accept(this);
    }

    private void appendAttributePath(StringBuilder sb, AttributeCondition attributeCondition) {
        sb.append(alias).append('.').append(attributeCondition.getAttributePath());
    }

    private void appendArgument(StringBuilder sb, Object argument) {
        if (argument instanceof String) {
            sb.append('\'').append(argument).append('\'');
            return;
        }
        if (argument instanceof Number) {
            sb.append(argument);
            return;
        }
        if (argument instanceof Boolean) {
            sb.append(this.renderBoolean((Boolean)argument));
            return;
        }
        if (argument instanceof Enum) {
            sb.append(this.renderEnum((Enum)argument));
            return;
        }
        if (argument instanceof Collection) {
            sb.append('(');
            boolean isFirstElement = true;
            for (Object o : (Collection)argument) {
                if (isFirstElement) {
                    isFirstElement = false;
                } else {
                    sb.append(", ");
                }
                this.appendArgument(sb, o);
            }
            sb.append(')');
            return;
        }
        if (argument instanceof Object[]) {
            sb.append('(');
            boolean isFirstElement = true;
            for (Object o : (Object[])argument) {
                if (isFirstElement) {
                    isFirstElement = false;
                } else {
                    sb.append(", ");
                }
                this.appendArgument(sb, o);
            }
            sb.append(')');
            return;
        }
        if (argument instanceof Date) {
            sb.append('\'').append(this.getDateFormatter().format(argument)).append('\'');
            return;
        }
        sb.append(argument);
    }

    private DateFormat getDateFormatter() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            this.dateFormat.setTimeZone(GMT_TZ);
        }
        return this.dateFormat;
    }
}

