/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import org.assertj.core.api.Assertions;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HibernateSearchPropertyHelperTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(new Class[]{TestEntity.class});
    private HibernateSearchPropertyHelper propertyHelper;

    @Before
    public void setup() {
        this.propertyHelper = new HibernateSearchPropertyHelper((SearchIntegrator)this.factoryHolder.getSearchFactory(), (EntityNameResolver)new ReflectionEntityNamesResolver(null));
    }

    private Object convertToPropertyType(Class<?> type, String propertyName, String value) {
        return this.propertyHelper.convertToPropertyType(type, new String[]{propertyName}, value);
    }

    @Test
    public void testConvertIdProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "id", "42")).isEqualTo((Object)"42");
    }

    @Test
    public void testConvertStringProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "name", "42")).isEqualTo((Object)"42");
    }

    @Test
    public void testConvertIntProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "i", "42")).isEqualTo((Object)42);
    }

    @Test
    public void testConvertLongProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "l", "42")).isEqualTo((Object)42L);
    }

    @Test
    public void testConvertFloatProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "f", "42.0")).isEqualTo((Object)Float.valueOf(42.0f));
    }

    @Test
    public void testConvertDoubleProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "d", "42.0")).isEqualTo((Object)42.0);
    }

    @Test
    public void testRecognizeAnalyzedField() {
        Assertions.assertThat((boolean)this.propertyHelper.getIndexedFieldProvider().get(TestEntity.class).isAnalyzed(new String[]{"description"})).isTrue();
    }

    @Test
    public void testRecognizeUnanalyzedField() {
        Assertions.assertThat((boolean)this.propertyHelper.getIndexedFieldProvider().get(TestEntity.class).isAnalyzed(new String[]{"i"})).isFalse();
    }

    @Indexed
    static class TestEntity {
        @DocumentId
        public String id;
        @Field(analyze=Analyze.NO)
        public String name;
        @Field(analyze=Analyze.YES)
        public String description;
        @Field(analyze=Analyze.NO)
        @NumericField
        public int i;
        @Field(analyze=Analyze.NO)
        @NumericField
        public long l;
        @Field(analyze=Analyze.NO)
        @NumericField
        public float f;
        @Field(analyze=Analyze.NO)
        @NumericField
        public double d;

        TestEntity() {
        }
    }
}

