/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.test;

import java.io.Serializable;
import java.util.Date;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.infinispan.marshall.core.ExternalPojo;
import org.infinispan.query.test.PersonAgeFilterFactory;
import org.infinispan.query.test.PersonBlurbFilterFactory;

@Indexed(index="person")
@FullTextFilterDefs(value={@FullTextFilterDef(name="personFilter", impl=PersonBlurbFilterFactory.class, cache=FilterCacheModeType.INSTANCE_AND_DOCIDSETRESULTS), @FullTextFilterDef(name="personAgeFilter", impl=PersonAgeFilterFactory.class, cache=FilterCacheModeType.INSTANCE_AND_DOCIDSETRESULTS)})
public class Person
implements Serializable,
ExternalPojo {
    private static final long serialVersionUID = 47806L;
    @Field(store=Store.YES)
    private String name;
    @Field(store=Store.YES)
    private String blurb;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    private int age;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @DateBridge(resolution=Resolution.DAY)
    private Date dateOfGraduation;
    private String nonIndexedField;

    public Person() {
    }

    public Person(String name, String blurb, int age) {
        this.name = name;
        this.blurb = blurb;
        this.age = age;
        this.nonIndexedField = name != null && name.length() >= 2 ? name.substring(0, 2) : null;
    }

    public Person(String name, String blurb, int age, Date dateOfGraduation) {
        this.name = name;
        this.blurb = blurb;
        this.age = age;
        this.dateOfGraduation = dateOfGraduation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBlurb() {
        return this.blurb;
    }

    public void setBlurb(String blurb) {
        this.blurb = blurb;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getNonIndexedField() {
        return this.nonIndexedField;
    }

    public void setNonIndexedField(String nonIndexedField) {
        this.nonIndexedField = nonIndexedField;
    }

    public Date getDateOfGraduation() {
        return this.dateOfGraduation;
    }

    public void setDateOfGraduation(Date dateOfGraduation) {
        this.dateOfGraduation = dateOfGraduation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.age != person.age) {
            return false;
        }
        if (this.blurb != null ? !this.blurb.equals(person.blurb) : person.blurb != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(person.name) : person.name != null) {
            return false;
        }
        if (this.nonIndexedField != null ? !this.nonIndexedField.equals(person.nonIndexedField) : person.nonIndexedField != null) {
            return false;
        }
        return this.dateOfGraduation != null ? this.dateOfGraduation.equals(person.dateOfGraduation) : person.dateOfGraduation == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.blurb != null ? this.blurb.hashCode() : 0);
        result = 31 * result + (this.nonIndexedField != null ? this.nonIndexedField.hashCode() : 0);
        result = 31 * result + (this.dateOfGraduation != null ? this.dateOfGraduation.hashCode() : 0);
        result = 31 * result + this.age;
        return result;
    }

    public String toString() {
        return "Person{name='" + this.name + "', blurb='" + this.blurb + "', age=" + this.age + ", dateOfGraduation=" + this.dateOfGraduation + ", nonIndexedField='" + this.nonIndexedField + "'}";
    }
}

