/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.query.affinity.FixedShardsDistribution;
import org.infinispan.remoting.transport.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.ShardDistributionTest")
public class ShardDistributionTest {
    private static final int MAX_SEGMENTS = 64;
    private static final int MAX_NODES = 3;

    @Test
    public void testAllocation() throws Exception {
        for (int nodes = 1; nodes < 3; ++nodes) {
            for (int segments = 1; segments < 64; ++segments) {
                for (int shards = 1; shards <= segments; ++shards) {
                    ShardDistributionTest.assertAllocation(nodes, segments, shards);
                }
            }
        }
    }

    @Test
    public void testDistributionWithNodesOwningNoSegments() throws Exception {
        TestAddress segmentsOwned = new TestAddress(1);
        TestAddress noSegmentOwned = new TestAddress(2);
        List<Address> members = Arrays.asList(segmentsOwned, noSegmentOwned);
        int segments = 256;
        int shards = 8;
        List[] owners = new List[segments];
        IntStream.range(0, segments).forEach(s -> {
            owners[s] = Collections.singletonList(segmentsOwned);
        });
        DefaultConsistentHash ch = new DefaultConsistentHash((Hash)MurmurHash3.getInstance(), 2, segments, members, null, owners);
        FixedShardsDistribution shardDistribution = new FixedShardsDistribution((ConsistentHash)ch, shards);
        AssertJUnit.assertEquals((int)8, (int)shardDistribution.getShardsIdentifiers().size());
        AssertJUnit.assertEquals((int)8, (int)shardDistribution.getShards((Address)segmentsOwned).size());
        AssertJUnit.assertTrue((shardDistribution.getShards((Address)noSegmentOwned) == null ? 1 : 0) != 0);
    }

    private static void assertAllocation(int numberOfNodes, int numberOfSegments, int numberOfShards) {
        ConsistentHash ch = ShardDistributionTest.createConsistentHash(numberOfSegments, numberOfNodes);
        FixedShardsDistribution shardDistribution = new FixedShardsDistribution(ch, numberOfShards);
        Set allShards = shardDistribution.getShardsIdentifiers();
        Set shardsFromSegments = IntStream.range(0, numberOfSegments).boxed().map(arg_0 -> ((FixedShardsDistribution)shardDistribution).getShardFromSegment(arg_0)).collect(Collectors.toSet());
        AssertJUnit.assertEquals((int)numberOfShards, (int)shardsFromSegments.size());
        AssertJUnit.assertEquals((int)numberOfShards, (int)allShards.size());
    }

    private static ConsistentHash createConsistentHash(int numSegments, int numNodes) {
        return ShardDistributionTest.createConsistentHash(numSegments, numNodes, 1);
    }

    private static ConsistentHash createConsistentHash(int numSegments, int numNodes, int numOwners) {
        if (numSegments == 0) {
            return null;
        }
        List servers = IntStream.range(0, numNodes).boxed().map(TestAddress::new).collect(Collectors.toList());
        List[] owners = new List[numSegments];
        IntStream.range(0, numSegments).boxed().forEach(segment -> {
            Collections.rotate(servers, 1);
            owners[segment.intValue()] = new ArrayList(servers.subList(0, numOwners));
        });
        return new DefaultConsistentHash((Hash)MurmurHash3.getInstance(), numOwners, numSegments, servers, null, owners);
    }
}

