/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.affinity.BaseAffinityTest;
import org.infinispan.query.affinity.Entity;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="query.IndexManagerPerfTest", timeOut=900000L)
public class IndexManagerPerfTest
extends BaseAffinityTest {
    private final AtomicInteger globalCounter = new AtomicInteger(0);
    private List<BaseAffinityTest.Node> nodes = new ArrayList<BaseAffinityTest.Node>();

    @Test
    public void testQueryWithWrites() throws Exception {
        this.nodes.addAll(IntStream.range(0, this.getIndexingNodes()).boxed().map(i -> new BaseAffinityTest.IndexingNode(this.getIndexThreadsPerNode(), this.globalCounter)).collect(Collectors.toList()));
        this.nodes.addAll(IntStream.range(0, this.getQueryingNodes()).boxed().map(i -> new BaseAffinityTest.QueryingNode(this.getQueryThreadsPerNode(), this.globalCounter, this.getQueryType())).collect(Collectors.toList()));
        this.nodes.forEach(BaseAffinityTest.Node::addToCluster);
        this.waitForClusterToForm();
        this.warmup();
        this.nodes.get((int)0).cacheManager.getCache().clear();
        this.summarizeReadWriteTest(this.runTests());
    }

    @Test
    public void testQueryOnly() throws Exception {
        this.nodes.addAll(IntStream.range(0, this.getQueryingNodes()).boxed().map(i -> new BaseAffinityTest.TimeBoundQueryNode(1L, TimeUnit.MINUTES, 100L, TimeUnit.MILLISECONDS, this.getQueryThreadsPerNode(), this.getQueryType())).collect(Collectors.toList()));
        this.nodes.forEach(BaseAffinityTest.Node::addToCluster);
        this.waitForClusterToForm();
        this.addDataToCluster(this.getNumEntries(), ProcessorInfo.availableProcessors() * 2);
        this.warmup();
        this.summarizeQueryOnlyTest(this.runTests());
    }

    private void summarizeReadWriteTest(long totalTimeMs) {
        Stream<BaseAffinityTest.NodeSummary> queryNodesSummary = this.getNodeSummary(BaseAffinityTest.QueryingNode.class, totalTimeMs);
        Stream<BaseAffinityTest.NodeSummary> nodeSummary = this.getNodeSummary(BaseAffinityTest.IndexingNode.class, totalTimeMs);
        nodeSummary.forEach(BaseAffinityTest.NodeSummary::outputHistogram);
        Optional<double[]> queryStats = this.averageQueryStats(queryNodesSummary);
        String query90th = queryStats.map(u -> String.valueOf(u[0])).orElse("N/A");
        String qps = queryStats.map(u -> String.valueOf(u[1])).orElse("N/A");
        double totalTimeSeconds = (double)totalTimeMs / 1000.0;
        Double writeOpsPerSecond = (double)this.getNumEntries() / ((double)totalTimeMs / 1000.0);
        System.out.printf("[Done in %fs] Shards: %s, index thread per node: %d, Query 90th: %s, QPS: %s, Put/s: %f\n", totalTimeSeconds, this.getNumShards(), this.getIndexThreadsPerNode(), query90th, qps, writeOpsPerSecond);
    }

    private void summarizeQueryOnlyTest(long totalTimeMs) {
        Stream<BaseAffinityTest.NodeSummary> queryNodesSummary = this.getNodeSummary(BaseAffinityTest.QueryingNode.class, totalTimeMs);
        double[] queryStats = this.averageQueryStats(queryNodesSummary).get();
        double totalTimeSeconds = (double)totalTimeMs / 1000.0;
        System.out.printf("[Done in %fs] Shards: %s, Query threads per node (%d nodes querying): %d, Query 90th: %f, QPS: %f\n", totalTimeSeconds, this.getNumShards(), this.getQueryThreadsPerNode(), this.getQueryingNodes(), queryStats[0], queryStats[1]);
    }

    private Stream<BaseAffinityTest.NodeSummary> getNodeSummary(Class<? extends BaseAffinityTest.Node> type, long totalTimeMs) {
        return this.nodes.stream().filter(n -> type.isAssignableFrom(n.getClass())).map(node -> node.getNodeSummary(totalTimeMs));
    }

    /*
     * Exception decompiling
     */
    private Optional<double[]> averageQueryStats(Stream<BaseAffinityTest.NodeSummary> queryNodesSummary) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @AfterMethod
    public void after() {
        this.nodes.forEach(BaseAffinityTest.Node::kill);
    }

    private long runTests() {
        long start = System.currentTimeMillis();
        ((Stream)this.nodes.stream().map(BaseAffinityTest.Node::run).parallel()).forEach(CompletableFuture::join);
        this.assertDocsIndexed(30000L);
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    private void addDataToCluster(int entries, int threads) {
        this.nodes.forEach(node -> {
            Cache<String, Entity> cache = node.cache;
            ((Stream)IntStream.range(0, threads).boxed().parallel()).forEach(t -> {
                int id;
                do {
                    if ((id = this.globalCounter.incrementAndGet()) > entries) continue;
                    cache.put((Object)String.valueOf(id), (Object)new Entity(id));
                    System.out.println("put " + id);
                } while (id <= entries);
            });
        });
    }

    private void warmup() {
        System.out.println("Warmup started");
        ((Stream)this.nodes.stream().parallel()).forEach(BaseAffinityTest.Node::warmup);
        System.out.println("Warmup finished");
    }

    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder builder, TransportFlags flags) {
        GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        EmbeddedCacheManager cm = TestCacheManagerFactory.newDefaultCacheManager((boolean)true, (GlobalConfigurationBuilder)gc, (ConfigurationBuilder)builder, (boolean)false);
        cm.defineConfiguration("LuceneIndexesLocking", this.getLockCacheConfig());
        cm.defineConfiguration("LuceneIndexesMetadata", this.getMetadataCacheConfig());
        cm.defineConfiguration("LuceneIndexesData", this.getDataCacheConfig());
        this.cacheManagers.add(cm);
        return cm;
    }

    protected void createCacheManagers() throws Throwable {
    }

    @Override
    protected String getReaderStrategy() {
        return "async";
    }

    private static /* synthetic */ double[] lambda$averageQueryStats$8(double[] a, double[] b) {
        return new double[]{(a[0] + b[0]) / 2.0, b[0] + b[1]};
    }
}

