/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.query.affinity.RpcCollector;
import org.infinispan.query.affinity.RpcDetail;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

class TrackingRpcManager
implements RpcManager {
    private final RpcManager delegate;
    private final RpcCollector rpcCollector;
    private final String cacheName;

    TrackingRpcManager(RpcManager delegate, RpcCollector rpcCollector, String cacheName) {
        this.delegate = delegate;
        this.rpcCollector = rpcCollector;
        this.cacheName = cacheName;
    }

    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), command, this.cacheName, Collections.singleton(target)));
        return this.delegate.invokeCommand(target, command, collector, rpcOptions);
    }

    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), command, this.cacheName, targets));
        return this.delegate.invokeCommand(targets, command, collector, rpcOptions);
    }

    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), command, this.cacheName, this.delegate.getTransport().getMembers()));
        return this.delegate.invokeCommandOnAll(command, collector, rpcOptions);
    }

    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), command, this.cacheName, targets));
        return this.delegate.invokeCommandStaggered(targets, command, collector, rpcOptions);
    }

    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        targets.forEach(target -> this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), (ReplicableCommand)commandGenerator.apply((Address)target), this.cacheName, Collections.singleton(target))));
        return this.delegate.invokeCommands(targets, commandGenerator, collector, rpcOptions);
    }

    public <T> T blocking(CompletionStage<T> request) {
        return (T)this.delegate.blocking(request);
    }

    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), rpc, this.cacheName, recipients));
        return this.delegate.invokeRemotelyAsync(recipients, rpc, options);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), rpc, this.cacheName, recipients));
        return this.delegate.invokeRemotely(recipients, rpc, options);
    }

    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcs, RpcOptions options) {
        rpcs.forEach((key, value) -> this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), (ReplicableCommand)value, this.cacheName, (Collection<Address>)Collections.singleton(key))));
        return this.delegate.invokeRemotely(rpcs, options);
    }

    public void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), command, this.cacheName, Collections.singletonList(destination)));
        this.delegate.sendTo(destination, command, deliverOrder);
    }

    public void sendToMany(Collection<Address> destinations, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), command, this.cacheName, destinations));
        this.delegate.sendToMany(destinations, command, deliverOrder);
    }

    public void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.rpcCollector.addRPC(new RpcDetail(this.getAddress(), command, this.cacheName, this.delegate.getMembers()));
        this.delegate.sendToAll(command, deliverOrder);
    }

    public BackupResponse invokeXSite(Collection<XSiteBackup> sites, XSiteReplicateCommand command) throws Exception {
        return this.delegate.invokeXSite(sites, command);
    }

    public Transport getTransport() {
        return this.delegate.getTransport();
    }

    public List<Address> getMembers() {
        return this.delegate.getMembers();
    }

    public Address getAddress() {
        return this.delegate.getAddress();
    }

    public int getTopologyId() {
        return this.delegate.getTopologyId();
    }

    public RpcOptions getSyncRpcOptions() {
        return this.delegate.getSyncRpcOptions();
    }

    public RpcOptions getTotalSyncRpcOptions() {
        return this.delegate.getTotalSyncRpcOptions();
    }

    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode) {
        return this.delegate.getRpcOptionsBuilder(responseMode);
    }

    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode, DeliverOrder deliverOrder) {
        return this.delegate.getRpcOptionsBuilder(responseMode, deliverOrder);
    }

    public RpcOptions getDefaultRpcOptions(boolean sync) {
        return this.delegate.getDefaultRpcOptions(sync);
    }

    public RpcOptions getDefaultRpcOptions(boolean sync, DeliverOrder deliverOrder) {
        return this.delegate.getDefaultRpcOptions(sync, deliverOrder);
    }
}

