/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.continuous.CallCountingCQResultListener;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractCQMultipleCachesTest
extends MultipleCacheManagersTest {
    protected final int NUM_NODES = 3;
    protected final int NUM_OWNERS = 2;

    protected abstract CacheMode getCacheMode();

    public AbstractCQMultipleCachesTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void createCacheManagers() {
        ConfigurationBuilder c = this.buildConfiguration();
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder c = AbstractCQMultipleCachesTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        c.clustering().hash().numOwners(2);
        return c;
    }

    protected CallCountingCQResultListener<Object, Object> createContinuousQuery() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache(0));
        Query query = qf.from(Person.class).having("age").lte((Object)30).build();
        CallCountingCQResultListener<Object, Object> listener = new CallCountingCQResultListener<Object, Object>();
        ContinuousQuery cq = Search.getContinuousQuery((Cache)this.cache(0));
        cq.addContinuousQueryListener(query, listener);
        return listener;
    }

    public void testContinuousQueryMultipleCaches() {
        Person value;
        int i;
        for (int i2 = 0; i2 < 2; ++i2) {
            Person value2 = new Person();
            value2.setName("John");
            value2.setAge(22);
            this.cache(i2).put((Object)i2, (Object)value2);
        }
        CallCountingCQResultListener<Object, Object> listener = this.createContinuousQuery();
        Map<Object, Integer> joined = listener.getJoined();
        Map<Object, Integer> left = listener.getLeft();
        AssertJUnit.assertEquals((int)2, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(40);
            this.cache(i).put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)2, (int)left.size());
        left.clear();
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache(0).put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)6, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        for (i = 0; i < 6; ++i) {
            AssertJUnit.assertEquals((int)1, (int)joined.get(i));
        }
        joined.clear();
        this.cache(0).clear();
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)6, (int)left.size());
        for (i = 0; i < 6; ++i) {
            AssertJUnit.assertEquals((int)1, (int)left.get(i));
        }
        left.clear();
    }

    public void testCQCacheLeavesAndJoins() {
        Person value;
        int i;
        CallCountingCQResultListener<Object, Object> listener = this.createContinuousQuery();
        Map<Object, Integer> joined = listener.getJoined();
        Map<Object, Integer> left = listener.getLeft();
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(40);
            this.cache(i).put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache(0).put((Object)i, (Object)value);
            if (i != 4) continue;
            this.killMember(1);
        }
        AssertJUnit.assertEquals((int)6, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        for (i = 0; i < 6; ++i) {
            AssertJUnit.assertEquals((int)1, (int)joined.get(i));
        }
        joined.clear();
        this.cache(0).clear();
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)6, (int)left.size());
        left.clear();
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache(0).put((Object)i, (Object)value);
            if (i != 4) continue;
            this.addClusterEnabledCacheManager(this.buildConfiguration());
        }
        AssertJUnit.assertEquals((int)6, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        for (i = 0; i < 6; ++i) {
            AssertJUnit.assertEquals((int)1, (int)joined.get(i));
        }
        joined.clear();
    }
}

