/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.SingleClassDSLQueryTest")
public class SingleClassDSLQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.configureCache(builder);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    protected void configureCache(ConfigurationBuilder builder) {
        builder.indexing().index(Index.ALL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() throws Exception {
        this.cache.put((Object)"person1", (Object)new Person("William", "Shakespeare", 50, "ZZ3141592", "M"));
    }

    protected void clearContent() {
    }

    public void testQueryInnerClass() throws Exception {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.from(Person.class).build();
        List matches = query.list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testField() throws Exception {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.from(Person.class).having("driverLicenseId").eq((Object)"ZZ3141592").build();
        List matches = query.list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField() throws Exception {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.from(Person.class).having("age").lte((Object)52).build();
        List matches = query.list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField2() throws Exception {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.from(Person.class).having("name").eq((Object)"William").build();
        List matches = query.list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField3() throws Exception {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.from(Person.class).having("gender").eq((Object)"M").build();
        List matches = query.list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField4() throws Exception {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.from(Person.class).having("surname").eq((Object)"Shakespeare").build();
        List matches = query.list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    @Indexed
    static class Person
    extends PersonBase {
        @Field(analyze=Analyze.NO)
        String driverLicenseId;
        String gender;

        public Person(String name, String surname, int age, String driverLicenseId, String gender) {
            super(name, surname, age);
            this.driverLicenseId = driverLicenseId;
            this.gender = gender;
        }

        @Override
        @Field(analyze=Analyze.NO)
        public String getGender() {
            return this.gender;
        }
    }

    static abstract class PersonBase
    implements PersonInterface {
        String name;
        String surname;
        @Field(analyze=Analyze.NO)
        int age;

        PersonBase(String name, String surname, int age) {
            this.name = name;
            this.surname = surname;
            this.age = age;
        }

        @Field(analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
        public String getSurname() {
            return this.surname;
        }

        @Override
        @Field(analyze=Analyze.NO)
        public String getName() {
            return this.name;
        }
    }

    static interface PersonInterface {
        public String getName();

        public String getGender();
    }
}

