/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;

public class TestableCluster<K, V> {
    private final List<EmbeddedCacheManager> cacheManagers = new ArrayList<EmbeddedCacheManager>();
    private final List<Cache<K, V>> caches = new ArrayList<Cache<K, V>>();
    private final String configurationResourceName;

    public TestableCluster(String configurationResourceName) {
        this.configurationResourceName = configurationResourceName;
    }

    public synchronized EmbeddedCacheManager startNewNode() {
        EmbeddedCacheManager cacheManager;
        try {
            cacheManager = TestCacheManagerFactory.fromXml((String)this.configurationResourceName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cacheManagers.add(cacheManager);
        Cache cache = cacheManager.getCache();
        this.caches.add(cache);
        TestableCluster.waitForStableTopology(cache, this.caches);
        return cacheManager;
    }

    public synchronized Cache<K, V> getCache(int nodeId) {
        return this.caches.get(nodeId);
    }

    public synchronized void killAll() {
        TestingUtil.killCacheManagers(this.cacheManagers);
        this.caches.clear();
        this.cacheManagers.clear();
    }

    public synchronized Iterable<Cache<K, V>> iterateAllCaches() {
        return new ArrayList<Cache<K, V>>(this.caches);
    }

    public synchronized void killNode(Cache<K, V> cache) {
        EmbeddedCacheManager cacheManager = cache.getCacheManager();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
        AssertJUnit.assertTrue((boolean)this.caches.remove(cache));
        AssertJUnit.assertTrue((boolean)this.cacheManagers.remove(cacheManager));
        TestableCluster.waitForStableTopology(cache, this.caches);
    }

    private static <K, V> void waitForStableTopology(Cache<K, V> cache, List<Cache<K, V>> caches) {
        if (cache.getCacheConfiguration().clustering().cacheMode() != CacheMode.LOCAL) {
            TestingUtil.waitForNoRebalance(caches);
        }
    }
}

