/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.searchmanager;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.spi.SearchManagerImplementor;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.searchmanager.TimeoutTest")
public class TimeoutTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(Foo.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test
    public void timeoutExceptionIsThrownAndIsProducedByMyFactory() {
        SearchManagerImplementor searchManager = (SearchManagerImplementor)Search.getSearchManager((Cache)this.cache).unwrap(SearchManagerImplementor.class);
        searchManager.setTimeoutExceptionFactory((TimeoutExceptionFactory)new MyTimeoutExceptionFactory());
        Query query = searchManager.buildQueryBuilderForClass(Foo.class).get().keyword().onField("bar").matching((Object)"1").createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(query, new Class[0]);
        cacheQuery.timeout(1L, TimeUnit.NANOSECONDS);
        try {
            cacheQuery.list();
            Assert.fail((String)"Expected MyTimeoutException");
        }
        catch (MyTimeoutException myTimeoutException) {
            // empty catch block
        }
    }

    @Indexed(index="FooIndex")
    public class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar")
        public String getBar() {
            return this.bar;
        }
    }

    public static class MyTimeoutException
    extends RuntimeException {
    }

    private static class MyTimeoutExceptionFactory
    implements TimeoutExceptionFactory {
        private MyTimeoutExceptionFactory() {
        }

        public RuntimeException createTimeoutException(String message, String query) {
            return new MyTimeoutException();
        }
    }
}

