/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.NoTransactionContext;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.impl.DefaultSearchWorkCreator;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.QueryInterceptorTest")
public class QueryInterceptorTest
extends AbstractInfinispanTest {
    private static final int MAX_CACHE_ENTRIES = 1;
    private File indexDir;
    private File storeDir;
    private final Person person1 = new Person("p1", "b1", 12);
    private final Person person2 = new Person("p2", "b2", 22);
    private final Car car1 = new Car("subaru", "blue", 200);
    private final Car car2 = new Car("lamborghini", "yellow", 230);

    @BeforeMethod
    protected void setup() throws Exception {
        this.indexDir = Files.createTempDirectory("test-", new FileAttribute[0]).toFile();
        this.storeDir = Files.createTempDirectory("test-", new FileAttribute[0]).toFile();
    }

    @AfterMethod
    protected void tearDown() {
        Util.recursiveFileRemove((File)this.indexDir);
        Util.recursiveFileRemove((File)this.storeDir);
    }

    @Test
    public void shouldNotReindexOnActivation() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(1)){

            public void call() {
                LuceneIndexTracker luceneIndexTracker = new LuceneIndexTracker(new File(QueryInterceptorTest.this.indexDir + "/person"));
                luceneIndexTracker.mark();
                Cache cache = this.cm.getCache();
                CacheListener cacheListener = new CacheListener();
                cache.addListener((Object)cacheListener);
                cache.put((Object)1, (Object)QueryInterceptorTest.this.person1);
                cache.put((Object)2, (Object)QueryInterceptorTest.this.person2);
                Assert.assertEquals((int)cacheListener.numberOfPassivations(), (int)1);
                Assert.assertEquals((int)cacheListener.numberOfActivations(), (int)0);
                Assert.assertTrue((boolean)luceneIndexTracker.indexChanged());
                luceneIndexTracker.mark();
                cache.get((Object)1);
                Assert.assertEquals((int)cacheListener.numberOfActivations(), (int)1);
                Assert.assertFalse((boolean)luceneIndexTracker.indexChanged());
            }
        });
    }

    @Test
    public void shouldNotReindexOnPreload() throws Exception {
        final LuceneIndexTracker luceneIndexTracker = new LuceneIndexTracker(new File(this.indexDir + "/person"));
        luceneIndexTracker.mark();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(1)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)1, (Object)QueryInterceptorTest.this.person1);
                cache.put((Object)2, (Object)QueryInterceptorTest.this.person2);
                Assert.assertTrue((boolean)luceneIndexTracker.indexChanged());
            }
        });
        luceneIndexTracker.mark();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(11)){

            public void call() {
                Cache cache = this.cm.getCache();
                CacheListener cacheListener = new CacheListener();
                cache.addListener((Object)cacheListener);
                Assert.assertTrue((boolean)cache.containsKey((Object)1));
                Assert.assertTrue((boolean)cache.containsKey((Object)2));
                Assert.assertEquals((int)cacheListener.numberOfPassivations(), (int)0);
                Assert.assertEquals((int)cacheListener.numberOfActivations(), (int)0);
                Assert.assertFalse((boolean)luceneIndexTracker.indexChanged());
            }
        });
    }

    @Test
    public void shouldDeleteSingleIndex() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(1)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)"P1", (Object)QueryInterceptorTest.this.person1);
                cache.put((Object)"P2", (Object)QueryInterceptorTest.this.person2);
                cache.put((Object)"C1", (Object)QueryInterceptorTest.this.car1);
                cache.put((Object)"C2", (Object)QueryInterceptorTest.this.car2);
                SearchManager searchManager = Search.getSearchManager((Cache)cache);
                Assert.assertEquals((int)2, (int)QueryInterceptorTest.this.countIndex(Car.class, cache));
                Assert.assertEquals((int)2, (int)QueryInterceptorTest.this.countIndex(Person.class, cache));
                searchManager.purge(Car.class);
                Assert.assertEquals((int)0, (int)QueryInterceptorTest.this.countIndex(Car.class, cache));
                Assert.assertEquals((int)2, (int)QueryInterceptorTest.this.countIndex(Person.class, cache));
                searchManager.purge(Person.class);
                Assert.assertEquals((int)0, (int)QueryInterceptorTest.this.countIndex(Car.class, cache));
                Assert.assertEquals((int)0, (int)QueryInterceptorTest.this.countIndex(Person.class, cache));
            }
        });
    }

    @Test
    public void shouldDeleteFromAllIndexesById() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createVolatileCacheManager()){

            public void call() {
                Cache cache = this.cm.getCache();
                IgnoreDeletesSearchWorkCreator searchWorkCreator = new IgnoreDeletesSearchWorkCreator();
                QueryInterceptor queryInterceptor = (QueryInterceptor)cache.getAdvancedCache().getComponentRegistry().getComponent(QueryInterceptor.class);
                queryInterceptor.setSearchWorkCreator((SearchWorkCreator)searchWorkCreator);
                cache.put((Object)"key", (Object)QueryInterceptorTest.this.person1);
                cache.put((Object)"key", (Object)QueryInterceptorTest.this.car1);
                Assert.assertEquals((int)1, (int)cache.size());
                Assert.assertEquals((int)1, (int)QueryInterceptorTest.this.countIndex(Person.class, cache));
                Assert.assertEquals((int)1, (int)QueryInterceptorTest.this.countIndex(Car.class, cache));
                queryInterceptor.removeFromIndexes((TransactionContext)NoTransactionContext.INSTANCE, (Object)"key");
                Assert.assertEquals((int)1, (int)cache.size());
                Assert.assertEquals((int)0, (int)QueryInterceptorTest.this.countIndex(Person.class, cache));
                Assert.assertEquals((int)0, (int)QueryInterceptorTest.this.countIndex(Car.class, cache));
            }
        });
    }

    protected EmbeddedCacheManager createCacheManager(int maxEntries) throws Exception {
        ConfigurationBuilder b = new ConfigurationBuilder();
        ((SingleFileStoreConfigurationBuilder)b.memory().evictionType(EvictionType.COUNT).size((long)maxEntries).persistence().passivation(true).addSingleFileStore().location(this.storeDir.getAbsolutePath()).preload(true)).indexing().index(Index.ALL).addIndexedEntity(Person.class).addIndexedEntity(Car.class).addProperty("default.directory_provider", "filesystem").addProperty("default.indexBase", this.indexDir.getAbsolutePath()).addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)b);
    }

    protected EmbeddedCacheManager createVolatileCacheManager() {
        ConfigurationBuilder b = new ConfigurationBuilder();
        b.indexing().index(Index.ALL).addIndexedEntity(Person.class).addIndexedEntity(Car.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)b);
    }

    private int countIndex(Class<?> entityType, Cache<?, ?> cache) {
        return Search.getSearchManager(cache).getQuery((Query)new MatchAllDocsQuery(), new Class[]{entityType}).getResultSize();
    }

    @Listener
    private static final class CacheListener {
        private final LongAdder passivationCount = new LongAdder();
        private final LongAdder activationCount = new LongAdder();

        private CacheListener() {
        }

        @CacheEntryPassivated
        public void onEvent(CacheEntryPassivatedEvent payload) {
            if (!payload.isPre()) {
                this.passivationCount.increment();
            }
        }

        @CacheEntryActivated
        public void onEvent(CacheEntryActivatedEvent payload) {
            if (!payload.isPre()) {
                this.activationCount.increment();
            }
        }

        public int numberOfPassivations() {
            return this.passivationCount.intValue();
        }

        public int numberOfActivations() {
            return this.activationCount.intValue();
        }
    }

    private static final class LuceneIndexTracker {
        private final File indexBase;
        private long indexVersion;

        public LuceneIndexTracker(File indexBase) {
            this.indexBase = indexBase;
        }

        public void mark() {
            this.indexVersion = this.getLuceneIndexVersion();
        }

        public boolean indexChanged() {
            return this.getLuceneIndexVersion() != this.indexVersion;
        }

        private long getLuceneIndexVersion() {
            return this.indexBase.list() == null ? -1L : SegmentInfos.getLastCommitGeneration((String[])this.indexBase.list());
        }
    }

    private class IgnoreDeletesSearchWorkCreator
    extends DefaultSearchWorkCreator {
        private IgnoreDeletesSearchWorkCreator() {
        }

        public Collection<Work> createPerEntityWorks(Object entity, Serializable id, WorkType workType) {
            if (workType.equals((Object)WorkType.DELETE)) {
                return Collections.emptySet();
            }
            return super.createPerEntityWorks(entity, id, workType);
        }
    }
}

