/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.testdomain.hsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.EncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.impl.BuiltinArrayBridge;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.Limits;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.LimitsHS;

@Indexed
public class AccountHS
implements Account,
Serializable {
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    private int id;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    private String description;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @DateBridge(encoding=EncodingType.STRING, resolution=Resolution.MILLISECOND)
    @SortableField
    private Date creationDate;
    @IndexedEmbedded(targetElement=LimitsHS.class, indexNullAs="__DEFAULT_NULL_TOKEN__")
    private Limits limits;
    @IndexedEmbedded(targetElement=LimitsHS.class, indexNullAs="__DEFAULT_NULL_TOKEN__")
    private Limits hardLimits;
    private List<byte[]> blurb = new ArrayList<byte[]>();
    @Field(store=Store.YES, analyze=Analyze.NO)
    @FieldBridge(impl=BuiltinArrayBridge.class)
    private Account.Currency[] currencies = new Account.Currency[0];

    public AccountHS() {
        this.hardLimits = new LimitsHS();
        this.hardLimits.setMaxTransactionLimit(5000.0);
        this.hardLimits.setMaxDailyLimit(10000.0);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Limits getLimits() {
        return this.limits;
    }

    @Override
    public void setLimits(Limits limits) {
        this.limits = limits;
    }

    @Override
    public Limits getHardLimits() {
        return this.hardLimits;
    }

    @Override
    public void setHardLimits(Limits hardLimits) {
        this.hardLimits = hardLimits;
    }

    @Override
    public List<byte[]> getBlurb() {
        return this.blurb;
    }

    @Override
    public void setBlurb(List<byte[]> blurb) {
        this.blurb = blurb;
    }

    private boolean blurbEquals(List<byte[]> otherBlurbs) {
        if (otherBlurbs == this.blurb) {
            return true;
        }
        if (otherBlurbs == null || this.blurb == null || otherBlurbs.size() != this.blurb.size()) {
            return false;
        }
        for (int i = 0; i < this.blurb.size(); ++i) {
            if (Arrays.equals(this.blurb.get(i), otherBlurbs.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Account.Currency[] getCurrencies() {
        return this.currencies;
    }

    @Override
    public void setCurrencies(Account.Currency[] currencies) {
        this.currencies = currencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHS account = (AccountHS)o;
        return this.id == account.id && Objects.equals(this.description, account.description) && Objects.equals(this.creationDate, account.creationDate) && Objects.equals(this.limits, account.limits) && Objects.equals(this.hardLimits, account.hardLimits) && this.blurbEquals(account.blurb) && Arrays.equals((Object[])this.currencies, (Object[])account.currencies);
    }

    public int hashCode() {
        int blurbHash = 0;
        if (this.blurb != null) {
            for (byte[] b : this.blurb) {
                blurbHash = 31 * blurbHash + Arrays.hashCode(b);
            }
        }
        return Objects.hash(this.id, this.description, this.creationDate, this.limits, this.hardLimits, blurbHash, Arrays.hashCode((Object[])this.currencies));
    }

    public String toString() {
        return "AccountHS{id=" + this.id + ", description='" + this.description + '\'' + ", creationDate='" + this.creationDate + '\'' + ", limits=" + this.limits + ", hardLimits=" + this.hardLimits + ", blurb=" + (this.blurb != null ? this.blurb.stream().map(Arrays::toString).collect(Collectors.toList()) : "null") + ", currencies=" + Arrays.toString((Object[])this.currencies) + '}';
    }
}

