/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Transaction;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.query.backend.QueryKnownClasses;
import org.infinispan.query.backend.TransactionHelper;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class SearchFactoryHandler {
    private static final Log log = (Log)LogFactory.getLog(SearchFactoryHandler.class, Log.class);
    private final SearchIntegrator searchFactory;
    private final QueryKnownClasses queryKnownClasses;
    private final TransactionHelper transactionHelper;
    private final Executor listenerExecutor;
    private final ClassLoader classLoader;
    private final Object cacheListener = new CacheListener();
    private final ReentrantLock mutating = new ReentrantLock();

    SearchFactoryHandler(SearchIntegrator searchFactory, QueryKnownClasses queryKnownClasses, TransactionHelper transactionHelper, Executor executor, ClassLoader classLoader) {
        this.searchFactory = searchFactory;
        this.queryKnownClasses = queryKnownClasses;
        this.transactionHelper = transactionHelper;
        this.listenerExecutor = executor;
        this.classLoader = classLoader;
    }

    boolean updateKnownTypesIfNeeded(Object value) {
        if (value != null) {
            Class<?> potentialNewType = value.getClass();
            Boolean existingBoolean = this.queryKnownClasses.get(potentialNewType);
            if (existingBoolean != null) {
                return existingBoolean;
            }
            this.handleOnDemandRegistration(false, potentialNewType);
            Boolean isIndexable = this.queryKnownClasses.get(potentialNewType);
            return isIndexable != null ? isIndexable : false;
        }
        return false;
    }

    private void handleOnDemandRegistration(boolean allowUndeclared, Class<?> ... classes) {
        ArrayList reducedSet = new ArrayList(classes.length);
        for (Class<?> type : classes) {
            if (this.queryKnownClasses.containsKey(type)) continue;
            reducedSet.add(type);
        }
        if (!reducedSet.isEmpty()) {
            if (this.queryKnownClasses.isAutodetectEnabled()) {
                Class[] toAdd = reducedSet.toArray(new Class[reducedSet.size()]);
                this.updateSearchFactoryInCallingThread(toAdd);
                for (Class c : toAdd) {
                    this.queryKnownClasses.put(c, this.hasIndex(c));
                }
            } else if (!allowUndeclared) {
                log.detectedUnknownIndexedEntities(this.queryKnownClasses.getCacheName(), ((Object)reducedSet).toString());
            }
        }
    }

    private CompletionStage<Void> updateSearchFactory(Class<?> ... classes) {
        return CompletableFuture.runAsync(() -> this.updateSearchFactoryInCallingThread(classes), this.listenerExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSearchFactoryInCallingThread(Class<?> ... classes) {
        this.mutating.lock();
        try {
            ArrayList reducedSet = new ArrayList(classes.length);
            for (Class<?> type : classes) {
                if (this.hasIndex(type)) continue;
                reducedSet.add(type);
            }
            if (reducedSet.isEmpty()) {
                return;
            }
            Class[] newtypes = reducedSet.toArray(new Class[reducedSet.size()]);
            Transaction tx = this.transactionHelper.suspendTxIfExists();
            try {
                this.searchFactory.addClasses(newtypes);
            }
            finally {
                this.transactionHelper.resume(tx);
            }
            for (Class type : newtypes) {
                if (!this.hasIndex(type)) continue;
                log.detectedUnknownIndexedEntity(this.queryKnownClasses.getCacheName(), type.getName());
            }
        }
        finally {
            this.mutating.unlock();
        }
    }

    boolean hasIndex(Class<?> c) {
        return this.searchFactory.getIndexBindings().get(c) != null;
    }

    private CompletionStage<Void> handleClusterRegistryRegistration(QueryKnownClasses.KnownClassKey knownClassKey) {
        Class<?> clazz = knownClassKey.getKnownClass(this.classLoader);
        if (this.hasIndex(clazz)) {
            return null;
        }
        return this.updateSearchFactory(clazz);
    }

    void enableClasses(Class[] classes) {
        this.handleOnDemandRegistration(true, classes);
    }

    Object getCacheListener() {
        return this.cacheListener;
    }

    @Listener
    final class CacheListener {
        CacheListener() {
        }

        @CacheEntryCreated
        public CompletionStage<Void> created(CacheEntryCreatedEvent<QueryKnownClasses.KnownClassKey, Boolean> e) {
            if (!e.isOriginLocal() && !e.isPre() && ((Boolean)e.getValue()).booleanValue()) {
                return SearchFactoryHandler.this.handleClusterRegistryRegistration((QueryKnownClasses.KnownClassKey)e.getKey());
            }
            return null;
        }

        @CacheEntryModified
        public CompletionStage<Void> modified(CacheEntryModifiedEvent<QueryKnownClasses.KnownClassKey, Boolean> e) {
            if (!e.isOriginLocal() && !e.isPre() && ((Boolean)e.getValue()).booleanValue()) {
                return SearchFactoryHandler.this.handleClusterRegistryRegistration((QueryKnownClasses.KnownClassKey)e.getKey());
            }
            return null;
        }
    }
}

