/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.assertj.core.api.Assertions;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParser;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryMaker;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryParsingResult;
import org.infinispan.query.dsl.embedded.impl.model.Employee;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LuceneTransformationTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(new Class[]{Employee.class});
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testRaiseExceptionDueToUnknownAlias() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028502: Unknown alias: a.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where a.name = 'same'");
    }

    @Test
    public void testMatchAllQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee", "*:*");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e", "*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e", "*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where true", "*:*");
    }

    @Test
    public void testRejectAllQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where false", "-*:* #*:*");
    }

    @Test
    public void testFullTextKeyword() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'bicycle'", "text:bicycle");
    }

    @Test
    public void testFullTextWildcard() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'geo*e'", "text:geo*e");
    }

    @Test
    public void testFullTextFuzzy() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'jonh'~2", "text:jonh~2");
    }

    @Test
    public void testFullTextPhrase() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'twisted cables'", "text:\"twisted cables\"");
    }

    @Test
    public void testFullTextRegexp() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : /te?t/", "text:/te?t/");
    }

    @Test
    public void testFullTextRange() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ['AAA' 'ZZZ']", "text:[aaa TO zzz]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ['AAA' to 'ZZZ']", "text:[aaa TO zzz]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : [* to 'eeee']", "text:[* TO eeee]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ['eeee' to *]", "text:[eeee TO *]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : [* *]", "text:[* TO *]");
    }

    @Test
    public void testFullTextFieldBoost() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'foo'^3.0'", "text:foo^3.0");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ('foo')^3.0'", "text:foo^3.0");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ('foo' and 'bar')^3.0'", "(+text:foo +text:bar)^3.0");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'foo'^3.0 || e.analyzedInfo : 'bar'", "text:foo^3.0 analyzedInfo:bar");
    }

    @Test
    public void testFullTextFieldOccur() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : (-'foo') ", "-text:foo #*:*");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : (-'foo' +'bar')", "(-text:foo) (+text:bar)");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where not e.text : (-'foo' +'bar')", "-((-text:foo) (+text:bar)) #*:*");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : (-'foo' '*')", "(-text:foo) text:*");
    }

    @Test
    public void testRestrictedQueryUsingSelect() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or e.id = 5", "name:same id:5");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' and e.id = 5", "+name:same +id:5");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' and not e.id = 5", "+name:same -id:5");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or not e.id = 5", "name:same (-id:5 #*:*)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where not e.id = 5", "-id:5 #*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.id != 5", "-id:5 #*:*");
    }

    @Test
    public void testFieldMapping() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.someMoreInfo = 'foo'", "someMoreInfo:foo");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.sameInfo = 'foo'", "sameInfo:foo");
    }

    @Test
    public void testWrongFieldName() {
        this.expectedException.expect(SearchException.class);
        this.expectedException.expectMessage("Unable to find field otherInfo in org.infinispan.query.dsl.embedded.impl.model.Employee");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.otherInfo = 'foo'");
    }

    @Test
    public void testProjectionQuery() {
        LuceneQueryParsingResult<Class<?>> parsingResult = this.parseAndTransform("select e.id, e.name from org.infinispan.query.dsl.embedded.impl.model.Employee e");
        Assertions.assertThat((String)parsingResult.getQuery().toString()).isEqualTo((Object)"*:*");
        Assertions.assertThat((Object[])parsingResult.getProjections()).isEqualTo((Object)new String[]{"id", "name"});
    }

    @Test
    public void testEmbeddedProjectionQuery() {
        LuceneQueryParsingResult<Class<?>> parsingResult = this.parseAndTransform("select e.author.name from org.infinispan.query.dsl.embedded.impl.model.Employee e");
        Assertions.assertThat((String)parsingResult.getQuery().toString()).isEqualTo((Object)"*:*");
        Assertions.assertThat((Object[])parsingResult.getProjections()).isEqualTo((Object)new String[]{"author.name"});
    }

    @Test
    public void testNestedEmbeddedProjectionQuery() {
        LuceneQueryParsingResult<Class<?>> parsingResult = this.parseAndTransform("select e.author.address.street from org.infinispan.query.dsl.embedded.impl.model.Employee e");
        Assertions.assertThat((String)parsingResult.getQuery().toString()).isEqualTo((Object)"*:*");
        Assertions.assertThat((Object[])parsingResult.getProjections()).isEqualTo((Object)new String[]{"author.address.street"});
    }

    @Test
    public void testQueryWithUnqualifiedPropertyReferences() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where name = 'same' and not id = 5", "+name:same -id:5");
    }

    @Test
    public void testNegatedQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where NOT e.name = 'same'", "-name:same #*:*");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name <> 'same'", "-name:same #*:*");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name != 'same'", "-name:same #*:*");
    }

    @Test
    public void testNegatedQueryOnNumericProperty() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position <> 3", "-position:[3 TO 3] #*:*");
    }

    @Test
    public void testNegatedRangeQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where name = 'Bob' and not position between 1 and 3", "+name:Bob -position:[1 TO 3]");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'Bob' and not e.position between 1 and 3", "+name:Bob -position:[1 TO 3]");
    }

    @Test
    public void testQueryWithNamedParameter() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("nameParameter", "Bob");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where name = :nameParameter", namedParameters, "name:Bob");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = :nameParameter", namedParameters, "name:Bob");
    }

    @Test
    public void testBooleanQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or (e.id = 4 and e.name = 'Bob')", "name:same (+id:4 +name:Bob)");
    }

    @Test
    public void testBooleanQueryUsingSelect() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or (e.id = 4 and e.name = 'Bob')", "name:same (+id:4 +name:Bob)");
    }

    @Test
    public void testBetweenQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name between 'aaa' and 'zzz'", "name:[aaa TO zzz]");
    }

    @Test
    public void testNotBetweenQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name not between 'aaa' and 'zzz'", "-name:[aaa TO zzz] #*:*");
    }

    @Test
    public void testNumericNotBetweenQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where not e.position between 1 and 3", "-position:[1 TO 3] #*:*");
    }

    @Test
    public void testBetweenQueryForCharacterLiterals() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name between 'a' and 'z'", "name:[a TO z]");
    }

    @Test
    public void testBetweenQueryWithNamedParameters() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("p1", "aaa");
        namedParameters.put("p2", "zzz");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name between :p1 and :p2", namedParameters, "name:[aaa TO zzz]");
    }

    @Test
    public void testNumericBetweenQuery() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("p1", 10L);
        namedParameters.put("p2", 20L);
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position between :p1 and :p2", namedParameters, "position:[10 TO 20]");
    }

    @Test
    public void testQueryWithEmbeddedPropertyInFromClause() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.author.name = 'Bob'", "author.name:Bob");
    }

    @Test
    public void testLessThanQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position < 100", "position:[* TO 100}");
    }

    @Test
    public void testLessThanOrEqualsToQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position <= 100", "position:[* TO 100]");
    }

    @Test
    public void testGreaterThanOrEqualsToQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where position >= 100", "position:[100 TO *]");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position >= 100", "position:[100 TO *]");
    }

    @Test
    public void testGreaterThanQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where position > 100", "position:{100 TO *]");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position > 100", "position:{100 TO *]");
    }

    @Test
    public void testInQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where name in ('Bob', 'Alice')", "name:Bob name:Alice");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name in ('Bob', 'Alice')", "name:Bob name:Alice");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position in (10, 20, 30, 40)", "position:[10 TO 10] position:[20 TO 20] position:[30 TO 30] position:[40 TO 40]");
    }

    @Test
    public void testInQueryWithNamedParameters() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("name1", "Bob");
        namedParameters.put("name2", "Alice");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name in (:name1, :name2)", namedParameters, "name:Bob name:Alice");
        namedParameters = new HashMap();
        namedParameters.put("pos1", 10);
        namedParameters.put("pos2", 20);
        namedParameters.put("pos3", 30);
        namedParameters.put("pos4", 40);
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position in (:pos1, :pos2, :pos3, :pos4)", namedParameters, "position:[10 TO 10] position:[20 TO 20] position:[30 TO 30] position:[40 TO 40]");
    }

    @Test
    public void testNotInQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name not in ('Bob', 'Alice')", "-(name:Bob name:Alice) #*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position not in (10, 20, 30, 40)", "-(position:[10 TO 10] position:[20 TO 20] position:[30 TO 30] position:[40 TO 40]) #*:*");
    }

    @Test
    public void testLikeQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Al_ce'", "name:Al?ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Ali%'", "name:Ali*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Ali%%'", "name:Ali**");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE '_l_ce'", "name:?l?ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE '___ce'", "name:???ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE '_%_ce'", "name:?*?ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Alice in wonderl%'", "name:Alice in wonderl*");
    }

    @Test
    public void testNotLikeQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name NOT LIKE 'Al_ce'", "-name:Al?ce #*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name NOT LIKE 'Ali%'", "-name:Ali* #*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name NOT LIKE '_l_ce' and not (e.title LIKE '%goo' and e.position = '5')", "-name:?l?ce -(+title:*goo +position:[5 TO 5]) #*:*");
    }

    @Test
    public void testIsNullQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name IS null", "name:_null_");
    }

    @Test
    public void testIsNullQueryForEmbeddedEntity() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.author IS null", "author:_null_");
    }

    @Test
    public void testIsNotNullQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name IS NOT null", "-name:_null_ #*:*");
    }

    @Test
    public void testCollectionOfEmbeddableQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.email = 'ninja647@mailinator.com' ", "contactDetails.email:ninja647@mailinator.com");
    }

    @Test
    public void testCollectionOfEmbeddableInEmbeddedQuery() {
        this.assertGeneratedLuceneQuery("SELECT e FROM org.infinispan.query.dsl.embedded.impl.model.Employee e  JOIN e.contactDetails d JOIN d.address.alternatives as a WHERE a.postCode = '90210' ", "contactDetails.address.alternatives.postCode:90210");
    }

    @Test
    public void testRaiseExceptionDueToUnknownQualifiedProperty() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee has no property named 'foobar'.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.foobar = 'same'");
    }

    @Test
    public void testRaiseExceptionDueToUnknownUnqualifiedProperty() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee has no property named 'foobar'.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where foobar = 'same'");
    }

    @Test
    public void testRaiseExceptionDueToAnalyzedPropertyInFromClause() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028522: No relational queries can be applied to property 'text' in type org.infinispan.query.dsl.embedded.impl.model.Employee since the property is analyzed.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text = 'foo'");
    }

    @Test
    public void testRaiseExceptionDueToUnknownPropertyInSelectClause() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee has no property named 'foobar'.");
        this.parseAndTransform("select e.foobar from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testRaiseExceptionDueToUnknownPropertyInEmbeddedSelectClause() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee has no property named 'foo'.");
        this.parseAndTransform("select e.author.foo from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testRaiseExceptionDueToSelectionOfCompleteEmbeddedEntity() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028503: Property author can not be selected from type org.infinispan.query.dsl.embedded.impl.model.Employee since it is an embedded entity.");
        this.parseAndTransform("select e.author from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testRaiseExceptionDueToUnqualifiedSelectionOfCompleteEmbeddedEntity() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028503: Property author can not be selected from type org.infinispan.query.dsl.embedded.impl.model.Employee since it is an embedded entity.");
        this.parseAndTransform("select author from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testDetermineTargetEntityType() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' and not e.id = 5");
        Assertions.assertThat((Class)((Class)result.getTargetEntityMetadata())).isSameAs(Employee.class);
        Assertions.assertThat((String)result.getTargetEntityName()).isEqualTo((Object)"org.infinispan.query.dsl.embedded.impl.model.Employee");
        result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e");
        Assertions.assertThat((Class)((Class)result.getTargetEntityMetadata())).isSameAs(Employee.class);
        Assertions.assertThat((String)result.getTargetEntityName()).isEqualTo((Object)"org.infinispan.query.dsl.embedded.impl.model.Employee");
    }

    @Test
    public void testBuildOneFieldSort() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title");
        Sort sort = result.getSort();
        Assertions.assertThat((Object)sort).isNotNull();
        Assertions.assertThat((int)sort.getSort().length).isEqualTo(1);
        Assertions.assertThat((String)sort.getSort()[0].getField()).isEqualTo((Object)"title");
        Assertions.assertThat((boolean)sort.getSort()[0].getReverse()).isEqualTo(false);
        Assertions.assertThat((Comparable)sort.getSort()[0].getType()).isEqualTo((Object)SortField.Type.STRING);
    }

    @Test
    public void testBuildTwoFieldsSort() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title, e.position DESC");
        Sort sort = result.getSort();
        Assertions.assertThat((Object)sort).isNotNull();
        Assertions.assertThat((int)sort.getSort().length).isEqualTo(2);
        Assertions.assertThat((String)sort.getSort()[0].getField()).isEqualTo((Object)"title");
        Assertions.assertThat((boolean)sort.getSort()[0].getReverse()).isEqualTo(false);
        Assertions.assertThat((Comparable)sort.getSort()[0].getType()).isEqualTo((Object)SortField.Type.STRING);
        Assertions.assertThat((String)sort.getSort()[1].getField()).isEqualTo((Object)"position");
        Assertions.assertThat((boolean)sort.getSort()[1].getReverse()).isEqualTo(true);
        Assertions.assertThat((Comparable)sort.getSort()[1].getType()).isEqualTo((Object)SortField.Type.LONG);
    }

    @Test
    public void testBuildSortForNullEncoding() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e order by e.code DESC");
        Sort sort = result.getSort();
        Assertions.assertThat((Object)sort).isNotNull();
        Assertions.assertThat((int)sort.getSort().length).isEqualTo(1);
        Assertions.assertThat((String)sort.getSort()[0].getField()).isEqualTo((Object)"code");
        Assertions.assertThat((Comparable)sort.getSort()[0].getType()).isEqualTo((Object)SortField.Type.LONG);
    }

    @Test
    public void testRaiseExceptionDueToUnrecognizedSortDirection() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028526: Invalid query: select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title DESblah, e.name ASC;");
        this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title DESblah, e.name ASC");
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbedded() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"*:*");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbedded() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode='EA123'");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"contactDetails.address.postCode:EA123");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseInOperator() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode IN ('EA123')");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"contactDetails.address.postCode:EA123");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseBetweenOperator() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode BETWEEN '0000' AND 'ZZZZ'");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"contactDetails.address.postCode:[0000 TO ZZZZ]");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseGreaterOperator() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode > '0000'");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"contactDetails.address.postCode:{0000 TO *]");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseLikeOperator() {
        LuceneQueryParsingResult<Class<?>> parsingResult = this.parseAndTransform("select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode LIKE 'EA1%'");
        Assertions.assertThat((String)parsingResult.getQuery().toString()).isEqualTo((Object)"contactDetails.address.postCode:EA1*");
        Assertions.assertThat((Object[])parsingResult.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToProjectUnqualifiedField() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("SELECT name, text FROM org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"*:*");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"name", "text"});
    }

    @Test
    public void testBeAbleToProjectUnqualifiedFieldAndQualifiedField() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("SELECT name, text, d.email FROM org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"*:*");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"name", "text", "contactDetails.email"});
    }

    @Test
    public void testBeAbleToProjectQualifiedField() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform("SELECT e.name, e.text, d.email FROM org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"*:*");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"name", "text", "contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithTwoEmbeddedCollections() {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform(" SELECT d.email  FROM org.infinispan.query.dsl.embedded.impl.model.Employee e  JOIN e.contactDetails d  JOIN e.alternativeContactDetails a WHERE d.address.postCode='EA123' AND a.email='ninja647@mailinator.com'");
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)"+contactDetails.address.postCode:EA123 +alternativeContactDetails.email:ninja647@mailinator.com");
        Assertions.assertThat((Object[])result.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    private void assertGeneratedLuceneQuery(String queryString, String expectedLuceneQuery) {
        this.assertGeneratedLuceneQuery(queryString, null, expectedLuceneQuery);
    }

    private void assertGeneratedLuceneQuery(String queryString, Map<String, Object> namedParameters, String expectedLuceneQuery) {
        LuceneQueryParsingResult<Class<?>> result = this.parseAndTransform(queryString, namedParameters);
        Assertions.assertThat((String)result.getQuery().toString()).isEqualTo((Object)expectedLuceneQuery);
    }

    private LuceneQueryParsingResult<Class<?>> parseAndTransform(String queryString) {
        return this.parseAndTransform(queryString, null);
    }

    private LuceneQueryParsingResult<Class<?>> parseAndTransform(String queryString, Map<String, Object> namedParameters) {
        ExtendedSearchIntegrator searchFactory = this.factoryHolder.getSearchFactory();
        HibernateSearchPropertyHelper propertyHelper = new HibernateSearchPropertyHelper((SearchIntegrator)searchFactory, (EntityNameResolver)new ReflectionEntityNamesResolver(null), LuceneTransformationTest.class.getClassLoader());
        IckleParsingResult ickleParsingResult = IckleParser.parse((String)queryString, (ObjectPropertyHelper)propertyHelper);
        LuceneQueryMaker luceneQueryMaker = new LuceneQueryMaker((SearchIntegrator)searchFactory, propertyHelper.getDefaultFieldBridgeProvider());
        return luceneQueryMaker.transform(ickleParsingResult, namedParameters, (Class)ickleParsingResult.getTargetEntityMetadata());
    }
}

