/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.nulls;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.transaction.TransactionManager;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.nulls.NullCollectionElementsClusteredTest")
public class NullCollectionElementsClusteredTest
extends MultipleCacheManagersTest {
    private Cache<String, Foo> cache1;
    private Cache<String, Foo> cache2;
    private SearchManager searchManager;

    public void testQuerySkipsNullsInList() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(1), () -> {
            this.cache2.remove((Object)"2");
            Cache<String, Foo> queryCache = this.getKeyLocation("2").equals(this.cache1) ? this.cache2 : this.cache1;
            this.searchManager = Search.getSearchManager(queryCache);
            Query query = this.createQueryBuilder().keyword().onField("bar").matching((Object)"2").createQuery();
            List list = this.searchManager.getQuery(query, new Class[0]).list();
            AssertJUnit.assertEquals((String)"Wrong list size.", (int)0, (int)list.size());
            return null;
        });
    }

    public void testQuerySkipsNullsInEagerIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            this.cache1.remove((Object)"1");
            this.searchManager = Search.getSearchManager(this.cache1);
            Query query = this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
            ResultIterator iterator = this.searchManager.getQuery(query, new Class[0]).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
            AssertJUnit.assertFalse((String)"Iterator should not have elements.", (boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    public void testQuerySkipsNullsInDefaultIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            Cache<String, Foo> cache = this.getKeyLocation("1");
            cache.remove((Object)"1");
            this.searchManager = Search.getSearchManager(cache);
            Query query = this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
            ResultIterator iterator = this.searchManager.getQuery(query, new Class[0]).iterator();
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    public void testQuerySkipsNullsInCacheQueryIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            Cache<String, Foo> cache = this.getKeyLocation("1");
            cache.remove((Object)"1");
            this.searchManager = Search.getSearchManager(cache);
            Query query = this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
            CacheQuery cacheQuery = this.searchManager.getQuery(query, new Class[0]);
            AssertJUnit.assertEquals((String)"Wrong result size.", (int)1, (int)cacheQuery.getResultSize());
            for (Object obj : cacheQuery) {
                AssertJUnit.fail((String)("The iterator should not contain any data but it contains " + obj));
            }
            return null;
        });
    }

    public void testQuerySkipsNullsInLazyIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(1), () -> {
            this.cache2.remove((Object)"2");
            Cache<String, Foo> queryCache = this.getKeyLocation("2").equals(this.cache1) ? this.cache2 : this.cache1;
            this.searchManager = Search.getSearchManager(queryCache);
            Query query = this.createQueryBuilder().keyword().onField("bar").matching((Object)"2").createQuery();
            ResultIterator iterator = this.searchManager.getQuery(query, new Class[0]).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    public void testQueryReturnsNullWhenProjectingCacheValue() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            Cache<String, Foo> cache = this.getKeyLocation("1");
            cache.remove((Object)"1");
            this.searchManager = Search.getSearchManager(cache);
            Query query = this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
            ResultIterator iterator = this.searchManager.getQuery(query, new Class[0]).projection(new String[]{"__HSearch_This", "bar"}).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
            AssertJUnit.assertTrue((String)"Expected an element in iterator.", (boolean)iterator.hasNext());
            Object[] projection = (Object[])iterator.next();
            AssertJUnit.assertNull((Object)projection[0]);
            AssertJUnit.assertEquals((Object)"1", (Object)projection[1]);
            return null;
        });
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = NullCollectionElementsClusteredTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        cfg.indexing().index(Index.PRIMARY_OWNER).addIndexedEntity(Foo.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, cfg);
        this.cache1 = this.cache(0);
        this.cache2 = this.cache(1);
    }

    private QueryBuilder createQueryBuilder() {
        return this.searchManager.buildQueryBuilderForClass(Foo.class).get();
    }

    private void prepareData() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            this.cache1.put((Object)"1", (Object)new Foo("1"));
            return null;
        });
        TestingUtil.withTx((TransactionManager)this.tm(1), () -> {
            this.cache2.put((Object)"2", (Object)new Foo("2"));
            return null;
        });
    }

    private Cache<String, Foo> getKeyLocation(String key) {
        Address cache1Address = this.cache1.getAdvancedCache().getRpcManager().getAddress();
        LocalizedCacheTopology cacheTopology = this.cache1.getAdvancedCache().getDistributionManager().getCacheTopology();
        DistributionInfo distribution = cacheTopology.getDistribution((Object)key);
        Address primary = distribution.primary();
        return primary.equals(cache1Address) ? this.cache1 : this.cache2;
    }

    @Indexed(index="FooIndex")
    public static class Foo
    implements Serializable {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar", store=Store.YES)
        public String getBar() {
            return this.bar;
        }
    }
}

