/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredQueryTest")
public class ClusteredQueryTest
extends MultipleCacheManagersTest {
    private final QueryParser queryParser = TestQueryHelperFactory.createQueryParser("blurb");
    static final int NUM_ENTRIES = 50;
    Cache<String, Person> cacheAMachine1;
    Cache<String, Person> cacheAMachine2;
    private CacheQuery<Person> cacheQuery;
    protected StorageType storageType;

    public Object[] factory() {
        return new Object[]{new ClusteredQueryTest().storageType(StorageType.OFF_HEAP), new ClusteredQueryTest().storageType(StorageType.BINARY), new ClusteredQueryTest().storageType(StorageType.OBJECT)};
    }

    protected String[] parameterNames() {
        return (String[])ClusteredQueryTest.concat((Object[])super.parameterNames(), (Object[])new String[]{"StorageType"});
    }

    protected Object[] parameterValues() {
        return ClusteredQueryTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.storageType});
    }

    ClusteredQueryTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @AfterMethod
    protected void clearContent() {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredQueryTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        cacheCfg.indexing().index(Index.PRIMARY_OWNER).addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        cacheCfg.memory().storageType(this.storageType);
        List caches = this.createClusteredCaches(2, cacheCfg);
        this.cacheAMachine1 = (Cache)caches.get(0);
        this.cacheAMachine2 = (Cache)caches.get(1);
        this.populateCache();
    }

    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    protected void prepareTestData() {
        IntStream.range(0, 50).boxed().map(i -> new Person("name" + i, "blurb" + i, (int)i)).forEach(p -> {
            Cache<String, Person> cache = p.getAge() % 2 == 0 ? this.cacheAMachine1 : this.cacheAMachine2;
            cache.put((Object)p.getName(), p);
        });
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLazyOrdered() {
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        for (int i = 0; i < 2; ++i) {
            try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
                assert (this.cacheQuery.getResultSize() == 10) : this.cacheQuery.getResultSize();
                int previousAge = 0;
                while (iterator.hasNext()) {
                    Person person = (Person)iterator.next();
                    assert (person.getAge() > previousAge);
                    previousAge = person.getAge();
                }
                continue;
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLazyNonOrdered() {
        try (ResultIterator ignored = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            assert (this.cacheQuery.getResultSize() == 10) : this.cacheQuery.getResultSize();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLocalQuery() throws ParseException {
        SearchManager searchManager1 = Search.getSearchManager(this.cacheAMachine1);
        CacheQuery localQuery1 = searchManager1.getQuery((org.apache.lucene.search.Query)this.createLuceneQuery(), new Class[0]);
        List results1 = localQuery1.list();
        SearchManager searchManager2 = Search.getSearchManager(this.cacheAMachine2);
        CacheQuery localQuery2 = searchManager2.getQuery((org.apache.lucene.search.Query)this.createLuceneQuery(), new Class[0]);
        List results2 = localQuery2.list();
        AssertJUnit.assertEquals((int)10, (int)(results1.size() + results2.size()));
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testEagerOrdered() {
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
            int previousAge = 0;
            while (iterator.hasNext()) {
                Person person = (Person)iterator.next();
                assert (person.getAge() > previousAge);
                previousAge = person.getAge();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testIteratorNextOutOfBounds() {
        this.cacheQuery.maxResults(1);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (iterator.hasNext());
            iterator.next();
            assert (!iterator.hasNext());
            iterator.next();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() {
        this.cacheQuery.maxResults(1);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (iterator.hasNext());
            iterator.remove();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testList() {
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        List results = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
        int previousAge = 0;
        for (Person person : results) {
            assert (person.getAge() > previousAge);
            previousAge = person.getAge();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testGetResultSizeList() {
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
    }

    public void testPagination() {
        this.cacheQuery.firstResult(2);
        this.cacheQuery.maxResults(1);
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        List results = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
        Person result = (Person)results.get(0);
        AssertJUnit.assertEquals((int)12, (int)result.getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test
    public void testPagination2() {
        int[] pageSizes;
        for (int pageSize : pageSizes = new int[]{1, 5, 7, 60}) {
            this.testPaginationWithoutSort(pageSize);
            this.testPaginationWithSort(pageSize, "age", SortField.Type.INT);
        }
    }

    private void testPaginationWithoutSort(int pageSize) {
        this.testPaginationInternal(pageSize, null);
    }

    private void testPaginationWithSort(int pageSize, String field, SortField.Type type) {
        this.testPaginationInternal(pageSize, new Sort(new SortField(field, type)));
    }

    private void testPaginationInternal(int pageSize, Sort sort) {
        CacheQuery<Person> paginationQuery = this.buildPaginationQuery(0, pageSize, sort);
        int idx = 0;
        HashSet keys = new HashSet();
        while (idx < 50) {
            List results = paginationQuery.list();
            results.stream().map(Person::getName).forEach(keys::add);
            paginationQuery = this.buildPaginationQuery(idx += pageSize, pageSize, sort);
        }
        AssertJUnit.assertEquals((int)50, (int)keys.size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    private CacheQuery<Person> buildPaginationQuery(int offset, int pageSize, Sort sort) {
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getQuery((org.apache.lucene.search.Query)new MatchAllDocsQuery(), IndexedQueryMode.BROADCAST, new Class[0]);
        clusteredQuery.firstResult(offset);
        clusteredQuery.maxResults(pageSize);
        if (sort != null) {
            clusteredQuery.sort(sort);
        }
        return clusteredQuery;
    }

    public void testQueryAll() {
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getQuery((org.apache.lucene.search.Query)new MatchAllDocsQuery(), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        AssertJUnit.assertEquals((int)50, (int)clusteredQuery.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testFuzzyQuery() throws ParseException {
        this.populateCache();
        org.apache.lucene.search.Query query = this.queryParser.parse("name:name1~2");
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(query, IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        AssertJUnit.assertEquals((int)50, (int)clusteredQuery.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastIckleMatchAllQuery() {
        CacheQuery everybody = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        AssertJUnit.assertEquals((int)50, (int)everybody.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastIckleTermQuery() {
        String targetName = "name2";
        CacheQuery singlePerson = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.name:'%s'", Person.class.getName(), targetName), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        AssertJUnit.assertEquals((int)1, (int)singlePerson.list().size());
        AssertJUnit.assertEquals((String)targetName, (String)((Person)singlePerson.list().iterator().next()).getName());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastFuzzyIckle() {
        CacheQuery persons0to10 = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.name:'nome'~2", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        AssertJUnit.assertEquals((int)10, (int)persons0to10.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastNumericRangeQuery() {
        CacheQuery infants = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.age between 0 and 5", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        AssertJUnit.assertEquals((int)6, (int)infants.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastProjectionIckleQuery() {
        SearchManager sm = Search.getSearchManager(this.cacheAMachine2);
        CacheQuery onlyNames = sm.getQuery(String.format("Select p.name FROM %s p", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        List results = onlyNames.list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        HashSet names = new HashSet();
        results.iterator().forEachRemaining(s -> names.add((String)s[0]));
        Set allNames = IntStream.range(0, 50).boxed().map(i -> "name" + i).collect(Collectors.toSet());
        AssertJUnit.assertEquals(allNames, names);
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastSortedIckleQuery() {
        SearchManager sm = Search.getSearchManager(this.cacheAMachine2);
        CacheQuery theLastWillBeFirst = sm.getQuery(String.format("FROM %s p order by p.age desc", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        List results = theLastWillBeFirst.list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        AssertJUnit.assertEquals((int)49, (int)((Person)results.iterator().next()).getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testPaginatedIckleQuery() {
        SearchManager sm = Search.getSearchManager(this.cacheAMachine1);
        CacheQuery q = sm.getQuery(String.format("FROM %s p order by p.age", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        q.firstResult(5);
        q.maxResults(10);
        List results = q.list();
        AssertJUnit.assertEquals((int)10, (int)results.size());
        AssertJUnit.assertEquals((String)"name5", (String)((Person)results.iterator().next()).getName());
        AssertJUnit.assertEquals((String)"name14", (String)((Person)results.get(9)).getName());
    }

    public void testPartialIckleQuery() {
        SearchManager searchManager1 = Search.getSearchManager(this.cacheAMachine1);
        SearchManager searchManager2 = Search.getSearchManager(this.cacheAMachine2);
        String query = String.format("FROM %s p", Person.class.getName());
        CacheQuery machine1Results = searchManager1.getQuery(query, IndexedQueryMode.FETCH, new Class[]{Person.class});
        CacheQuery machine2Results = searchManager2.getQuery(query, IndexedQueryMode.FETCH, new Class[]{Person.class});
        int numDocsMachine1 = this.countLocalIndex(this.cacheAMachine1);
        int numDocsMachine2 = this.countLocalIndex(this.cacheAMachine2);
        AssertJUnit.assertEquals((int)50, (int)(numDocsMachine1 + numDocsMachine2));
        AssertJUnit.assertEquals((int)numDocsMachine1, (int)machine1Results.list().size());
        AssertJUnit.assertEquals((int)numDocsMachine2, (int)machine2Results.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    private int countLocalIndex(Cache<String, Person> cache) {
        SearchManager sm = Search.getSearchManager(cache);
        ExtendedSearchIntegrator esi = (ExtendedSearchIntegrator)sm.unwrap(ExtendedSearchIntegrator.class);
        IndexReader indexReader = esi.getIndexManager("person").getReaderProvider().openIndexReader();
        return indexReader.numDocs();
    }

    @Test(expectedExceptions={SearchException.class}, expectedExceptionsMessageRegExp=".*cannot be converted to an indexed query")
    public void testPreventHybridQuery() {
        CacheQuery hybridQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.nonIndexedField = 'nothing'", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        hybridQuery.list();
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*cannot be converted to an indexed query")
    public void testPreventAggregationQueries() {
        CacheQuery aggregationQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.name:'name3' group by p.name", Person.class.getName()), IndexedQueryMode.BROADCAST, new Class[]{Person.class});
        aggregationQuery.list();
    }

    @Test
    public void testBroadcastNativeInfinispanMatchAllQuery() {
        String q = String.format("FROM %s", Person.class.getName());
        Query partialResultQuery = Search.getQueryFactory(this.cacheAMachine1).create(q);
        Query fullResultQuery = Search.getQueryFactory(this.cacheAMachine2).create(q, IndexedQueryMode.BROADCAST);
        int docsInMachine1 = this.countLocalIndex(this.cacheAMachine1);
        AssertJUnit.assertEquals((int)docsInMachine1, (int)partialResultQuery.list().size());
        AssertJUnit.assertEquals((int)50, (int)fullResultQuery.list().size());
    }

    @Test
    public void testBroadcastNativeInfinispanHybridQuery() {
        String q = "FROM " + Person.class.getName() + " where age >= 40 and nonIndexedField = 'na'";
        Query query = Search.getQueryFactory(this.cacheAMachine1).create(q, IndexedQueryMode.BROADCAST);
        AssertJUnit.assertEquals((int)10, (int)query.list().size());
    }

    @Test
    public void testBroadcastNativeInfinispanFuzzyQuery() {
        String q = String.format("FROM %s p where p.name:'nome'~2", Person.class.getName());
        Query query = Search.getQueryFactory(this.cacheAMachine1).create(q, IndexedQueryMode.BROADCAST);
        AssertJUnit.assertEquals((int)10, (int)query.list().size());
    }

    @Test
    public void testBroadcastSortedInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine1);
        Query sortedQuery = queryFactory.create("FROM " + Person.class.getName() + " p order by p.age desc", IndexedQueryMode.BROADCAST);
        List results = sortedQuery.list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        AssertJUnit.assertEquals((int)49, (int)((Person)results.iterator().next()).getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test
    public void testBroadcastAggregatedInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine2);
        Query hybridQuery = queryFactory.create("select name FROM " + Person.class.getName() + " WHERE name : 'na*' group by name", IndexedQueryMode.BROADCAST);
        AssertJUnit.assertEquals((int)50, (int)hybridQuery.list().size());
    }

    @Test
    public void testNonIndexedBroadcastInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine2);
        Query slowQuery = queryFactory.create("FROM " + Person.class.getName() + " WHERE nonIndexedField LIKE 'na%'", IndexedQueryMode.BROADCAST);
        AssertJUnit.assertEquals((int)50, (int)slowQuery.list().size());
    }

    protected void populateCache() throws ParseException {
        this.prepareTestData();
        this.cacheQuery = Search.getSearchManager(this.cacheAMachine1).getQuery((org.apache.lucene.search.Query)this.createLuceneQuery(), IndexedQueryMode.BROADCAST, new Class[0]);
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    protected BooleanQuery createLuceneQuery() throws ParseException {
        return new BooleanQuery.Builder().add(this.queryParser.parse("blurb1?"), BooleanClause.Occur.SHOULD).build();
    }
}

