/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.lucene.search.BooleanQuery;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.affinity.ShardAllocationManagerImpl;
import org.infinispan.query.affinity.ShardAllocatorManager;
import org.infinispan.query.backend.IndexModificationStrategy;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.query.backend.TxQueryInterceptor;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.QueryBox;
import org.infinispan.query.continuous.impl.ContinuousQueryResult;
import org.infinispan.query.continuous.impl.IckleContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryEngine;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.IckleCacheEventFilterConverter;
import org.infinispan.query.dsl.embedded.impl.IckleFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.DefaultSearchMappingProvider;
import org.infinispan.query.impl.IndexPropertyInspector;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.query.impl.PersistenceContextInitializerImpl;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.impl.SecurityActions;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.LuceneBooleanQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneBytesRefExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFieldDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFuzzyQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneMatchAllQueryExternalizer;
import org.infinispan.query.impl.externalizers.LucenePrefixQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneScoreDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortFieldExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopFieldDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneWildcardQueryExternalizer;
import org.infinispan.query.impl.massindex.DistributedExecutorMassIndexer;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.logging.Log;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.LogFactory;

@InfinispanModule(name="query", requiredModules={"core"}, optionalModules={"lucene-directory"})
public class LifecycleManager
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    public static final String MAX_BOOLEAN_CLAUSES_SYS_PROP = "infinispan.query.lucene.max-boolean-clauses";
    private static boolean maxBooleanClausesWasSet = false;
    private MBeanServer mbeanServer;

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName) || icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.QUERYABLE)) {
            AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
            ClassLoader aggregatedClassLoader = this.makeAggregatedClassLoader(cr.getGlobalComponentRegistry().getGlobalConfiguration().classLoader());
            SearchIntegrator searchFactory = null;
            boolean isIndexed = cfg.indexing().index().isEnabled();
            if (isIndexed) {
                this.setBooleanQueryMaxClauseCount();
                cr.registerComponent((Object)new ShardAllocationManagerImpl(), ShardAllocatorManager.class);
                searchFactory = this.createSearchIntegrator(cfg.indexing(), cr, aggregatedClassLoader);
                KeyTransformationHandler keyTransformationHandler = new KeyTransformationHandler(aggregatedClassLoader);
                cr.registerComponent((Object)keyTransformationHandler, KeyTransformationHandler.class);
                this.createQueryInterceptorIfNeeded((BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class), cfg, cache, searchFactory, keyTransformationHandler);
                this.addCacheDependencyIfNeeded(cacheName, cache.getCacheManager(), cfg.indexing());
                cr.registerComponent((Object)new QueryBox(), QueryBox.class);
            }
            this.registerMatcher(cr, searchFactory, aggregatedClassLoader);
            cr.registerComponent((Object)new EmbeddedQueryEngine(cache, isIndexed), EmbeddedQueryEngine.class);
        }
    }

    private void registerMatcher(ComponentRegistry cr, SearchIntegrator searchFactory, ClassLoader classLoader) {
        ReflectionMatcher reflectionMatcher = searchFactory == null ? new ReflectionMatcher(classLoader) : new ReflectionMatcher((ObjectPropertyHelper)new HibernateSearchPropertyHelper(searchFactory, (EntityNameResolver)new ReflectionEntityNamesResolver(classLoader)));
        cr.registerComponent((Object)reflectionMatcher, ReflectionMatcher.class);
    }

    private void addCacheDependencyIfNeeded(String cacheStarting, EmbeddedCacheManager cacheManager, IndexingConfiguration indexingConfiguration) {
        if (indexingConfiguration.indexedEntities().isEmpty()) {
            SecurityActions.addCacheDependency(cacheManager, cacheStarting, "___query_known_classes");
        }
        if (IndexPropertyInspector.hasInfinispanDirectory((Properties)indexingConfiguration.properties())) {
            String metadataCacheName = IndexPropertyInspector.getMetadataCacheName((Properties)indexingConfiguration.properties());
            String lockingCacheName = IndexPropertyInspector.getLockingCacheName((Properties)indexingConfiguration.properties());
            String dataCacheName = IndexPropertyInspector.getDataCacheName((Properties)indexingConfiguration.properties());
            if (!(cacheStarting.equals(metadataCacheName) || cacheStarting.equals(lockingCacheName) || cacheStarting.equals(dataCacheName))) {
                SecurityActions.addCacheDependency(cacheManager, cacheStarting, metadataCacheName);
                SecurityActions.addCacheDependency(cacheManager, cacheStarting, lockingCacheName);
                SecurityActions.addCacheDependency(cacheManager, cacheStarting, dataCacheName);
            }
        }
    }

    private void createQueryInterceptorIfNeeded(BasicComponentRegistry cr, Configuration cfg, AdvancedCache<?, ?> cache, SearchIntegrator searchIntegrator, KeyTransformationHandler keyTransformationHandler) {
        log.registeringQueryInterceptor(cache.getName());
        ComponentRef queryInterceptorRef = cr.getComponent(QueryInterceptor.class);
        if (queryInterceptorRef != null) {
            return;
        }
        ConcurrentHashMap<GlobalTransaction, Map<Object, Object>> txOldValues = new ConcurrentHashMap<GlobalTransaction, Map<Object, Object>>();
        IndexModificationStrategy indexingStrategy = IndexModificationStrategy.configuredStrategy(searchIntegrator, cfg);
        QueryInterceptor queryInterceptor = new QueryInterceptor(searchIntegrator, keyTransformationHandler, indexingStrategy, txOldValues, cache);
        for (Map.Entry kt : cfg.indexing().keyTransformers().entrySet()) {
            keyTransformationHandler.registerTransformer((Class)kt.getKey(), (Class)kt.getValue());
        }
        AsyncInterceptorChain ic = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class).wired();
        EntryWrappingInterceptor wrappingInterceptor = (EntryWrappingInterceptor)ic.findInterceptorExtending(EntryWrappingInterceptor.class);
        AsyncInterceptor lastLoadingInterceptor = ic.findInterceptorExtending(CacheLoaderInterceptor.class);
        if (lastLoadingInterceptor == null) {
            lastLoadingInterceptor = wrappingInterceptor;
        }
        ic.addInterceptorAfter((AsyncInterceptor)queryInterceptor, lastLoadingInterceptor.getClass());
        cr.registerComponent(QueryInterceptor.class, (Object)queryInterceptor, true);
        cr.addDynamicDependency(AsyncInterceptorChain.class.getName(), QueryInterceptor.class.getName());
        if (cfg.transaction().transactionMode().isTransactional()) {
            TxQueryInterceptor txQueryInterceptor = new TxQueryInterceptor(txOldValues, queryInterceptor);
            ic.addInterceptorBefore((AsyncInterceptor)txQueryInterceptor, wrappingInterceptor.getClass());
            cr.registerComponent(TxQueryInterceptor.class, (Object)txQueryInterceptor, true);
            cr.addDynamicDependency(AsyncInterceptorChain.class.getName(), TxQueryInterceptor.class.getName());
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        IndexingConfiguration indexingConfiguration = configuration.indexing();
        if (!indexingConfiguration.index().isEnabled()) {
            if (this.verifyChainContainsQueryInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the Query interceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
        SearchIntegrator searchFactory = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        if (!indexingConfiguration.indexedEntities().isEmpty()) {
            TypedProperties indexingProperties = indexingConfiguration.properties();
            if (IndexPropertyInspector.hasInfinispanDirectory((Properties)indexingProperties)) {
                String metadataCacheName = IndexPropertyInspector.getMetadataCacheName((Properties)indexingProperties);
                String lockingCacheName = IndexPropertyInspector.getLockingCacheName((Properties)indexingProperties);
                String dataCacheName = IndexPropertyInspector.getDataCacheName((Properties)indexingProperties);
                if (cacheName.equals(dataCacheName) && (cacheName.equals(metadataCacheName) || cacheName.equals(lockingCacheName))) {
                    Class[] indexedEntities = indexingConfiguration.indexedEntities().toArray(new Class[indexingConfiguration.indexedEntities().size()]);
                    searchFactory.addClasses(indexedEntities);
                    this.checkIndexableClasses(searchFactory, indexingConfiguration.indexedEntities());
                }
            } else {
                this.checkIndexableClasses(searchFactory, indexingConfiguration.indexedEntities());
            }
        }
        this.registerQueryMBeans(cr, configuration, searchFactory);
    }

    private void checkIndexableClasses(SearchIntegrator searchFactory, Set<Class<?>> indexedEntities) {
        for (Class<?> c : indexedEntities) {
            if (searchFactory.getIndexBinding((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(c)) != null) continue;
            throw log.classNotIndexable(c.getName());
        }
    }

    private void registerQueryMBeans(ComponentRegistry cr, Configuration cfg, SearchIntegrator searchIntegrator) {
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        GlobalConfiguration globalConfig = cr.getGlobalComponentRegistry().getGlobalConfiguration();
        GlobalJmxStatisticsConfiguration jmxConfig = globalConfig.globalJmxStatistics();
        if (!jmxConfig.enabled()) {
            return;
        }
        if (this.mbeanServer == null) {
            this.mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)jmxConfig.mbeanServerLookup(), (Properties)jmxConfig.properties());
        }
        String queryGroupName = this.getQueryGroupName(globalConfig.cacheManagerName(), cache.getName());
        String jmxDomain = JmxUtil.buildJmxDomain((String)jmxConfig.domain(), (MBeanServer)this.mbeanServer, (String)queryGroupName);
        try {
            ObjectName statsObjName = new ObjectName(jmxDomain + ":" + queryGroupName + ",component=Statistics");
            InfinispanQueryStatisticsInfo stats = new InfinispanQueryStatisticsInfo(searchIntegrator, statsObjName);
            stats.setStatisticsEnabled(cfg.jmxStatistics().enabled());
            JmxUtil.registerMBean((Object)stats, (ObjectName)statsObjName, (MBeanServer)this.mbeanServer);
            cr.registerComponent((Object)stats, InfinispanQueryStatisticsInfo.class);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register query statistics MBean", (Throwable)e);
        }
        try {
            KeyTransformationHandler keyTransformationHandler = ComponentRegistryUtils.getKeyTransformationHandler(cache);
            TimeService timeService = ComponentRegistryUtils.getTimeService(cache);
            DistributedExecutorMassIndexer massIndexer = new DistributedExecutorMassIndexer(cache, searchIntegrator, keyTransformationHandler, timeService);
            CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)cr.getComponent(CacheManagerJmxRegistration.class);
            jmxRegistration.registerExternalMBean((Object)massIndexer, jmxDomain, queryGroupName, null);
        }
        catch (Exception e) {
            throw new CacheException("Unable to create MassIndexer MBean", (Throwable)e);
        }
    }

    private String getQueryGroupName(String cacheManagerName, String cacheName) {
        return "type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName);
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        AsyncInterceptorChain interceptorChain = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        return interceptorChain != null && interceptorChain.containsInterceptorType(QueryInterceptor.class, true);
    }

    private SearchIntegrator createSearchIntegrator(IndexingConfiguration indexingConfiguration, ComponentRegistry cr, ClassLoader aggregatedClassLoader) {
        SearchIntegrator searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        if (searchIntegrator != null && !searchIntegrator.isStopped()) {
            throw new IllegalStateException("SearchIntegrator already initialized!");
        }
        LinkedHashSet<ProgrammaticSearchMappingProvider> programmaticSearchMappingProviders = new LinkedHashSet<ProgrammaticSearchMappingProvider>();
        programmaticSearchMappingProviders.add(new DefaultSearchMappingProvider());
        programmaticSearchMappingProviders.addAll(ServiceFinder.load(ProgrammaticSearchMappingProvider.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader}));
        Collection analyzerDefProviders = ServiceFinder.load(LuceneAnalysisDefinitionProvider.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader});
        SearchableCacheConfiguration config = new SearchableCacheConfiguration(indexingConfiguration.indexedEntities(), (Properties)indexingConfiguration.properties(), programmaticSearchMappingProviders, analyzerDefProviders, cr, aggregatedClassLoader);
        searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)config).buildSearchIntegrator();
        cr.registerComponent((Object)searchIntegrator, SearchIntegrator.class);
        return searchIntegrator;
    }

    private ClassLoader makeAggregatedClassLoader(ClassLoader globalClassLoader) {
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>(6);
        if (globalClassLoader != null) {
            classLoaders.add(globalClassLoader);
        }
        classLoaders.add(AggregatedClassLoader.class.getClassLoader());
        classLoaders.add(ClassLoaderService.class.getClassLoader());
        classLoaders.add(this.getClass().getClassLoader());
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                classLoaders.add(tccl);
            }
        }
        catch (Exception tccl) {
            // empty catch block
        }
        try {
            ClassLoader syscl = ClassLoader.getSystemClassLoader();
            if (syscl != null) {
                classLoaders.add(syscl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AggregatedClassLoader(classLoaders);
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        SearchIntegrator searchIntegrator;
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor != null) {
            queryInterceptor.prepareForStopping();
        }
        if ((searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class)) != null) {
            searchIntegrator.close();
        }
        this.unregisterQueryMBeans(cr, cacheName);
    }

    private void unregisterQueryMBeans(ComponentRegistry cr, String cacheName) {
        if (this.mbeanServer != null) {
            try {
                InfinispanQueryStatisticsInfo stats = (InfinispanQueryStatisticsInfo)cr.getComponent(InfinispanQueryStatisticsInfo.class);
                if (stats != null) {
                    GlobalConfiguration globalConfig = cr.getGlobalComponentRegistry().getGlobalConfiguration();
                    String queryGroupName = this.getQueryGroupName(globalConfig.cacheManagerName(), cacheName);
                    String queryMBeanFilter = stats.getObjectName().getDomain() + ":" + queryGroupName + ",*";
                    JmxUtil.unregisterMBeans((String)queryMBeanFilter, (MBeanServer)this.mbeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Unable to unregister query MBeans", (Throwable)e);
            }
        }
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        gcr.registerComponent((Object)new QueryCache(), QueryCache.class);
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        PersistenceMarshaller persistenceMarshaller = (PersistenceMarshaller)bcr.getComponent("org.infinispan.marshaller.persistence", PersistenceMarshaller.class).wired();
        persistenceMarshaller.register((SerializationContextInitializer)new PersistenceContextInitializerImpl());
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_AND_CONVERTER, new IckleFilterAndConverter.IckleFilterAndConverterExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_RESULT, new IckleFilterAndConverter.FilterResultExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CACHE_EVENT_FILTER_CONVERTER, new IckleCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new IckleContinuousQueryCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT, new ContinuousQueryResult.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_BOOLEAN, new LuceneBooleanQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_TERM, new LuceneTermQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TERM, new LuceneTermExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT, new LuceneSortExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT_FIELD, new LuceneSortFieldExternalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_TOPDOCS, new NodeTopDocs.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPDOCS, new LuceneTopDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_FIELD_SCORE_DOC, new LuceneFieldDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SCORE_DOC, new LuceneScoreDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPFIELDDOCS, new LuceneTopFieldDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_MATCH_ALL, new LuceneMatchAllQueryExternalizer());
        externalizerMap.put(ExternalizerIds.INDEX_WORKER, new IndexWorker.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_BYTES_REF, new LuceneBytesRefExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_PREFIX, new LucenePrefixQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_WILDCARD, new LuceneWildcardQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_FUZZY, new LuceneFuzzyQueryExternalizer());
        externalizerMap.put(ExternalizerIds.QUERY_DEFINITION, new QueryDefinition.Externalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_COMMAND_RESPONSE, new QueryResponse.Externalizer());
    }

    public void cacheManagerStopped(GlobalComponentRegistry gcr) {
        this.mbeanServer = null;
    }

    private void setBooleanQueryMaxClauseCount() {
        if (!maxBooleanClausesWasSet) {
            maxBooleanClausesWasSet = true;
            String maxClauseCountProp = SecurityActions.getSystemProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP);
            if (maxClauseCountProp != null) {
                int maxClauseCount;
                try {
                    maxClauseCount = Integer.parseInt(maxClauseCountProp);
                }
                catch (NumberFormatException e) {
                    log.failedToParseSystemProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP, e);
                    throw e;
                }
                int currentMaxClauseCount = BooleanQuery.getMaxClauseCount();
                if (maxClauseCount > currentMaxClauseCount) {
                    log.settingBooleanQueryMaxClauseCount(MAX_BOOLEAN_CLAUSES_SYS_PROP, maxClauseCount);
                    BooleanQuery.setMaxClauseCount((int)maxClauseCount);
                } else {
                    log.ignoringBooleanQueryMaxClauseCount(MAX_BOOLEAN_CLAUSES_SYS_PROP, maxClauseCount, currentMaxClauseCount);
                }
            }
        }
    }
}

