/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.AddCacheDependencyAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;

final class SecurityActions {
    private SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)(System.getSecurityManager() != null ? AccessController.doPrivileged(action) : Security.doPrivileged(action));
    }

    static String getSystemProperty(String propertyName) {
        return SecurityActions.doPrivileged(() -> System.getProperty(propertyName));
    }

    static Configuration getCacheConfiguration(Cache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getCacheConfiguration());
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        return (ComponentRegistry)SecurityActions.doPrivileged(new GetCacheComponentRegistryAction(cache));
    }

    static void addCacheDependency(EmbeddedCacheManager cacheManager, String cacheStarting, String queryKnownClassesCacheName) {
        SecurityActions.doPrivileged(new AddCacheDependencyAction(cacheManager, cacheStarting, queryKnownClassesCacheName));
    }
}

