package org.infinispan.query.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.infinispan.partitionhandling.AvailabilityException;
import javax.annotation.Generated;
import org.infinispan.remoting.transport.Address;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import java.lang.Exception;
import javax.transaction.Transaction;
import org.jboss.logging.BasicLogger;
import org.infinispan.objectfilter.ParsingException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-10-04T18:47:11+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String classNotIndexable = "ISPN000404: The configured entity class %s is not indexable. Please remove it from the indexing configuration.";
    protected String classNotIndexable$str() {
        return classNotIndexable;
    }
    @Override
    public final CacheConfigurationException classNotIndexable(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), classNotIndexable$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keyClassNotFound(final String keyClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, keyClassNotFound$str(), keyClassName);
    }
    private static final String keyClassNotFound = "ISPN014001: Could not locate key class %s";
    protected String keyClassNotFound$str() {
        return keyClassNotFound;
    }
    @Override
    public final void couldNotInstantiaterTransformerClass(final Class<?> transformer, final Exception e) {
        super.log.logf(FQCN, ERROR, e, couldNotInstantiaterTransformerClass$str(), transformer);
    }
    private static final String couldNotInstantiaterTransformerClass = "ISPN014002: Cannot instantiate Transformer class %s";
    protected String couldNotInstantiaterTransformerClass$str() {
        return couldNotInstantiaterTransformerClass;
    }
    @Override
    public final void registeringQueryInterceptor(final String cacheName) {
        super.log.logf(FQCN, INFO, null, registeringQueryInterceptor$str(), cacheName);
    }
    private static final String registeringQueryInterceptor = "ISPN014003: Registering Query interceptor for cache %s";
    protected String registeringQueryInterceptor$str() {
        return registeringQueryInterceptor;
    }
    @Override
    public final void commandsBackendInitialized(final String indexName) {
        super.log.logf(FQCN, DEBUG, null, commandsBackendInitialized$str(), indexName);
    }
    private static final String commandsBackendInitialized = "ISPN014004: Custom commands backend initialized backing index %s";
    protected String commandsBackendInitialized$str() {
        return commandsBackendInitialized;
    }
    @Override
    public final void workListRemotedTo(final Object workList, final Address primaryNodeAddress) {
        super.log.logf(FQCN, TRACE, null, workListRemotedTo$str(), workList, primaryNodeAddress);
    }
    private static final String workListRemotedTo = "ISPN014005: Sent list of LuceneWork %s to node %s";
    protected String workListRemotedTo$str() {
        return workListRemotedTo;
    }
    @Override
    public final void applyingChangeListLocally(final java.util.List<org.hibernate.search.backend.LuceneWork> workList) {
        super.log.logf(FQCN, TRACE, null, applyingChangeListLocally$str(), workList);
    }
    private static final String applyingChangeListLocally = "ISPN014006: Apply list of LuceneWork %s delegating to local indexing engine";
    protected String applyingChangeListLocally$str() {
        return applyingChangeListLocally;
    }
    @Override
    public final void applyingChangeListRemotely(final java.util.List<org.hibernate.search.backend.LuceneWork> workList) {
        super.log.logf(FQCN, DEBUG, null, applyingChangeListRemotely$str(), workList);
    }
    private static final String applyingChangeListRemotely = "ISPN014007: Going to ship list of LuceneWork %s to a remote master indexer";
    protected String applyingChangeListRemotely$str() {
        return applyingChangeListRemotely;
    }
    @Override
    public final void ignoreDirectoryProviderProperty(final String indexName, final String directoryOption) {
        super.log.logf(FQCN, WARN, null, ignoreDirectoryProviderProperty$str(), indexName, directoryOption);
    }
    private static final String ignoreDirectoryProviderProperty = "ISPN014008: Index named '%1$s' is ignoring configuration option 'directory_provider' set '%2$s': overridden to use the Infinispan Directory";
    protected String ignoreDirectoryProviderProperty$str() {
        return ignoreDirectoryProviderProperty;
    }
    @Override
    public final void typeIsUsingDefaultTransformer(final Class<?> keyClass) {
        super.log.logf(FQCN, WARN, null, typeIsUsingDefaultTransformer$str(), keyClass);
    }
    private static final String typeIsUsingDefaultTransformer = "ISPN014009: Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable";
    protected String typeIsUsingDefaultTransformer$str() {
        return typeIsUsingDefaultTransformer;
    }
    private static final String unexpectedIOException = "ISPN014010: An IOException happened where none where expected";
    protected String unexpectedIOException$str() {
        return unexpectedIOException;
    }
    @Override
    public final CacheException unexpectedIOException(final IOException e) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unexpectedIOException$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void interruptedWhileBufferingWork(final InterruptedException e) {
        super.log.logf(FQCN, WARN, e, interruptedWhileBufferingWork$str());
    }
    private static final String interruptedWhileBufferingWork = "ISPN014011: Some indexing work was lost because of an InterruptedException";
    protected String interruptedWhileBufferingWork$str() {
        return interruptedWhileBufferingWork;
    }
    @Override
    public final void waitingForLockAcquired(final boolean waitForAvailabilityInternal) {
        super.log.logf(FQCN, DEBUG, null, waitingForLockAcquired$str(), waitForAvailabilityInternal);
    }
    private static final String waitingForLockAcquired = "ISPN014012: Waiting for index lock was successful: '%1$s'";
    protected String waitingForLockAcquired$str() {
        return waitingForLockAcquired;
    }
    private static final String cacheIsStoppingNoCommandAllowed = "ISPN014013: Cache named '%1$s' is being shut down. No longer accepting remote commands.";
    protected String cacheIsStoppingNoCommandAllowed$str() {
        return cacheIsStoppingNoCommandAllowed;
    }
    @Override
    public final CacheException cacheIsStoppingNoCommandAllowed(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheIsStoppingNoCommandAllowed$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void indexingEntitiesCompleted(final long nbrOfEntities) {
        super.log.logf(FQCN, INFO, null, indexingEntitiesCompleted$str(), nbrOfEntities);
    }
    private static final String indexingEntitiesCompleted = "ISPN014014: Reindexed %1$d entities";
    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }
    @Override
    public final void indexingDocumentsCompleted(final long doneCount, final long elapsedMs) {
        super.log.logf(FQCN, INFO, null, indexingDocumentsCompleted$str(), doneCount, elapsedMs);
    }
    private static final String indexingDocumentsCompleted = "ISPN014015: %1$d documents indexed in %2$d ms";
    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }
    @Override
    public final void purgingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, purgingIndex$str(), entityType);
    }
    private static final String purgingIndex = "ISPN014016: Purging instances of '%s' from the index";
    protected String purgingIndex$str() {
        return purgingIndex;
    }
    @Override
    public final void flushingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, flushingIndex$str(), entityType);
    }
    private static final String flushingIndex = "ISPN014017: Flushing index '%s'";
    protected String flushingIndex$str() {
        return flushingIndex;
    }
    private static final String cannotRunLuceneQueriesIfNotIndexed = "ISPN014019: Cannot run Lucene queries on a cache '%s' that does not have indexing enabled";
    protected String cannotRunLuceneQueriesIfNotIndexed$str() {
        return cannotRunLuceneQueriesIfNotIndexed;
    }
    @Override
    public final IllegalStateException cannotRunLuceneQueriesIfNotIndexed(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRunLuceneQueriesIfNotIndexed$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupingAndAggregationQueriesMustUseProjections = "ISPN014021: Queries containing grouping and aggregation functions must use projections.";
    protected String groupingAndAggregationQueriesMustUseProjections$str() {
        return groupingAndAggregationQueriesMustUseProjections;
    }
    @Override
    public final ParsingException groupingAndAggregationQueriesMustUseProjections() {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), groupingAndAggregationQueriesMustUseProjections$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotHaveAggregationsInGroupByClause = "ISPN014022: Cannot have aggregate functions in GROUP BY clause";
    protected String cannotHaveAggregationsInGroupByClause$str() {
        return cannotHaveAggregationsInGroupByClause;
    }
    @Override
    public final IllegalStateException cannotHaveAggregationsInGroupByClause() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotHaveAggregationsInGroupByClause$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multivaluedPropertyCannotBeUsedInGroupBy = "ISPN014023: Using the multi-valued property path '%s' in the GROUP BY clause is not currently supported";
    protected String multivaluedPropertyCannotBeUsedInGroupBy$str() {
        return multivaluedPropertyCannotBeUsedInGroupBy;
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInGroupBy(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeUsedInGroupBy$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multivaluedPropertyCannotBeUsedInOrderBy = "ISPN014024: The property path '%s' cannot be used in the ORDER BY clause because it is multi-valued";
    protected String multivaluedPropertyCannotBeUsedInOrderBy$str() {
        return multivaluedPropertyCannotBeUsedInOrderBy;
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInOrderBy(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeUsedInOrderBy$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String queryMustNotUseGroupingOrAggregation = "ISPN014025: The query must not use grouping or aggregation";
    protected String queryMustNotUseGroupingOrAggregation$str() {
        return queryMustNotUseGroupingOrAggregation;
    }
    @Override
    public final IllegalStateException queryMustNotUseGroupingOrAggregation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryMustNotUseGroupingOrAggregation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause = "ISPN014026: The expression '%s' must be part of an aggregate function or it should be included in the GROUP BY clause";
    protected String expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str() {
        return expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause;
    }
    @Override
    public final ParsingException expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multivaluedPropertyCannotBeProjected = "ISPN014027: The property path '%s' cannot be projected because it is multi-valued";
    protected String multivaluedPropertyCannotBeProjected$str() {
        return multivaluedPropertyCannotBeProjected;
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeProjected(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeProjected$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void detectedUnknownIndexedEntity(final String cacheName, final String className) {
        super.log.logf(FQCN, WARN, null, detectedUnknownIndexedEntity$str(), cacheName, className);
    }
    private static final String detectedUnknownIndexedEntity = "ISPN014028: Autodetected a new indexed entity type in cache %s: %s. Autodetection support will be removed in Infinispan 10.0.";
    protected String detectedUnknownIndexedEntity$str() {
        return detectedUnknownIndexedEntity;
    }
    @Override
    public final void detectedUnknownIndexedEntities(final String cacheName, final String classNames) {
        super.log.logf(FQCN, WARN, null, detectedUnknownIndexedEntities$str(), cacheName, classNames);
    }
    private static final String detectedUnknownIndexedEntities = "ISPN014029: Found undeclared indexable types in cache %s : %s. No indexes were created for these types because autodetection is not enabled for this cache.";
    protected String detectedUnknownIndexedEntities$str() {
        return detectedUnknownIndexedEntities;
    }
    private static final String notAnIndexedEntityException = "ISPN014030: The type %s is not an indexed entity.";
    protected String notAnIndexedEntityException$str() {
        return notAnIndexedEntityException;
    }
    @Override
    public final IllegalArgumentException notAnIndexedEntityException(final String typeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAnIndexedEntityException$str(), typeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResumeSuspendedTx = "ISPN014033: Unable to resume suspended transaction %s";
    protected String unableToResumeSuspendedTx$str() {
        return unableToResumeSuspendedTx;
    }
    @Override
    public final CacheException unableToResumeSuspendedTx(final Transaction transaction, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToResumeSuspendedTx$str(), transaction), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToSuspendTx = "ISPN014034: Unable to suspend transaction";
    protected String unableToSuspendTx$str() {
        return unableToSuspendTx;
    }
    @Override
    public final CacheException unableToSuspendTx(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToSuspendTx$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy = "ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy: %s";
    protected String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str() {
        return getPrefixWildcardOrRegexpQueriesCannotBeFuzzy;
    }
    @Override
    public final ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(final String s) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getInvalidBooleanLiteralException = "ISPN014037: Invalid boolean literal '%s'";
    protected String getInvalidBooleanLiteralException$str() {
        return getInvalidBooleanLiteralException;
    }
    @Override
    public final ParsingException getInvalidBooleanLiteralException(final String value) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), getInvalidBooleanLiteralException$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String queryModuleNotInitialised = "ISPN014038: infinispan-query.jar module is in the classpath but has not been properly initialised!";
    protected String queryModuleNotInitialised$str() {
        return queryModuleNotInitialised;
    }
    @Override
    public final CacheException queryModuleNotInitialised() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), queryModuleNotInitialised$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupAggregationsNotSupported = "ISPN014039: Queries containing groups or aggregations cannot be converted to an indexed query";
    protected String groupAggregationsNotSupported$str() {
        return groupAggregationsNotSupported;
    }
    @Override
    public final CacheException groupAggregationsNotSupported() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), groupAggregationsNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String filterNotSupportedWithQueryString = "ISPN014040: Unable to define filters, please use filters in the query string instead.";
    protected String filterNotSupportedWithQueryString$str() {
        return filterNotSupportedWithQueryString;
    }
    @Override
    public final CacheException filterNotSupportedWithQueryString() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), filterNotSupportedWithQueryString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sortNotSupportedWithQueryString = "ISPN014041: Unable to define sort, please use sorting in the query string instead.";
    protected String sortNotSupportedWithQueryString$str() {
        return sortNotSupportedWithQueryString;
    }
    @Override
    public final CacheException sortNotSupportedWithQueryString() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), sortNotSupportedWithQueryString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String partitionDegraded = "ISPN014042: Cannot execute query: cluster is operating in degraded mode and partition handling configuration doesn't allow reads and writes.";
    protected String partitionDegraded$str() {
        return partitionDegraded;
    }
    @Override
    public final AvailabilityException partitionDegraded() {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), partitionDegraded$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransformerForKey = "ISPN014043: Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.";
    protected String noTransformerForKey$str() {
        return noTransformerForKey;
    }
    @Override
    public final CacheException noTransformerForKey(final String keyClassName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noTransformerForKey$str(), keyClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToParseSystemProperty(final String propertyName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToParseSystemProperty$str(), propertyName);
    }
    private static final String failedToParseSystemProperty = "ISPN014044: Failed to parse system property %s";
    protected String failedToParseSystemProperty$str() {
        return failedToParseSystemProperty;
    }
    @Override
    public final void overridingBooleanQueryMaxClauseCount(final int maxClauseCount) {
        super.log.logf(FQCN, DEBUG, null, overridingBooleanQueryMaxClauseCount$str(), maxClauseCount);
    }
    private static final String overridingBooleanQueryMaxClauseCount = "ISPN014045: Overriding org.apache.lucene.search.BooleanQuery.setMaxClauseCount to value %d to be able to deserialize a larger BooleanQuery";
    protected String overridingBooleanQueryMaxClauseCount$str() {
        return overridingBooleanQueryMaxClauseCount;
    }
    @Override
    public final void settingBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount) {
        super.log.logf(FQCN, INFO, null, settingBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount);
    }
    private static final String settingBooleanQueryMaxClauseCount = "ISPN014046: Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d";
    protected String settingBooleanQueryMaxClauseCount$str() {
        return settingBooleanQueryMaxClauseCount;
    }
    @Override
    public final void ignoringBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount, final int currentMaxClauseCount) {
        super.log.logf(FQCN, WARN, null, ignoringBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount, currentMaxClauseCount);
    }
    private static final String ignoringBooleanQueryMaxClauseCount = "ISPN014047: Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()";
    protected String ignoringBooleanQueryMaxClauseCount$str() {
        return ignoringBooleanQueryMaxClauseCount;
    }
}
