/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.QueryTestSCI;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DistProgrammaticMassIndexTest")
public class DistProgrammaticMassIndexTest
extends DistributedMassIndexingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(holder -> {
            String defaultName = "default";
            holder.getGlobalConfigurationBuilder().defaultCacheName(defaultName).serialization().addContextInitializer((SerializationContextInitializer)QueryTestSCI.INSTANCE);
            ConfigurationBuilder cacheCfg = DistProgrammaticMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
            cacheCfg.indexing().index(Index.PRIMARY_OWNER).addIndexedEntity(Car.class).addProperty("default.indexmanager", InfinispanIndexManager.class.getName()).addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT");
            cacheCfg.clustering().stateTransfer().fetchInMemoryState(true);
            holder.newConfigurationBuilder(defaultName).read(cacheCfg.build());
            Configuration cacheCfg1 = DistProgrammaticMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false).clustering().stateTransfer().fetchInMemoryState(true).build();
            holder.newConfigurationBuilder("LuceneIndexesData").read(cacheCfg1);
            holder.newConfigurationBuilder("LuceneIndexesLocking").read(cacheCfg1);
        }, 3);
        this.caches.addAll(this.caches());
    }

    @Override
    protected void verifyFindsCar(Cache cache, int count, String carMake) throws Exception {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("make");
        Query luceneQuery = queryParser.parse(carMake);
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(luceneQuery, new Class[]{Car.class});
        AssertJUnit.assertEquals((int)count, (int)cacheQuery.getResultSize());
        StaticTestingErrorHandler.assertAllGood(cache);
    }
}

