/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.Block;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.query.test.Transaction;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.OverlappingIndexMassIndexTest")
public class OverlappingIndexMassIndexTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 3;
    protected List<Cache<String, Object>> caches = new ArrayList<Cache<String, Object>>(3);

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = OverlappingIndexMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.indexing().index(Index.ALL).addIndexedEntity(Transaction.class).addIndexedEntity(Block.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        List cacheList = this.createClusteredCaches(3, QueryTestSCI.INSTANCE, cacheCfg);
        this.waitForClusterToForm(this.getDefaultCacheName());
        for (Cache cache : cacheList) {
            this.caches.add((Cache<String, Object>)cache);
        }
    }

    public void testReindex() throws Exception {
        Transaction t1 = new Transaction(302, "04a27");
        Transaction t2 = new Transaction(256, "ae461");
        Transaction t3 = new Transaction(257, "ac537");
        Block b1 = new Block(1, t1);
        Block b2 = new Block(2, t2);
        Block b3 = new Block(3, t3);
        this.caches.get(0).put((Object)"T1", (Object)t1);
        this.caches.get(0).put((Object)"T2", (Object)t2);
        this.caches.get(0).put((Object)"T3", (Object)t3);
        this.caches.get(0).put((Object)"B1", (Object)b1);
        this.caches.get(0).put((Object)"B2", (Object)b2);
        this.caches.get(0).put((Object)"B3", (Object)b3);
        this.checkIndex(3, Transaction.class, 3, Block.class);
        this.runMassIndexer();
        this.checkIndex(3, Transaction.class, 3, Block.class);
        this.caches.get(0).clear();
        this.runMassIndexer();
        this.checkIndex(0, Transaction.class, 0, Block.class);
    }

    protected void checkIndex(int expectedNumber, Class<?> entity, int otherExpected, Class<?> otherEntity) {
        for (Cache<String, Object> c : this.caches) {
            SearchManager searchManager = Search.getSearchManager(c);
            CacheQuery query1 = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{entity});
            CacheQuery query2 = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{otherEntity});
            AssertJUnit.assertEquals((int)expectedNumber, (int)query1.getResultSize());
            AssertJUnit.assertEquals((int)otherExpected, (int)query2.getResultSize());
        }
    }

    protected void runMassIndexer() {
        Cache<String, Object> cache = this.caches.get(0);
        SearchManager searchManager = Search.getSearchManager(cache);
        searchManager.getMassIndexer().start();
    }
}

