/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.concurrent.ExecutorService;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.stat.Statistics;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.clustered.ClusteredCacheQueryImpl;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.CacheQueryImpl;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.spi.SearchManagerImplementor;

public final class SearchManagerImpl
implements SearchManagerImplementor {
    private final AdvancedCache<?, ?> cache;
    private final SearchIntegrator searchFactory;
    private final QueryInterceptor queryInterceptor;
    private final KeyTransformationHandler keyTransformationHandler;
    private final QueryEngine<Class<?>> queryEngine;
    private final MassIndexer massIndexer;
    private TimeoutExceptionFactory timeoutExceptionFactory;

    public SearchManagerImpl(AdvancedCache<?, ?> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        this.cache = cache;
        this.searchFactory = ComponentRegistryUtils.getSearchIntegrator(cache);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        this.keyTransformationHandler = ComponentRegistryUtils.getKeyTransformationHandler(cache);
        this.queryEngine = ComponentRegistryUtils.getEmbeddedQueryEngine(cache);
        this.massIndexer = ComponentRegistryUtils.getMassIndexer(cache);
    }

    @Override
    public <E> CacheQuery<E> getQuery(Query luceneQuery, IndexedQueryMode indexedQueryMode, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        return this.queryEngine.buildCacheQuery(luceneQuery, indexedQueryMode, this.keyTransformationHandler, this.timeoutExceptionFactory, asyncExecutor, classes);
    }

    @Override
    public <E> CacheQuery<E> getQuery(String queryString, IndexedQueryMode indexedQueryMode, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        try {
            return this.queryEngine.buildCacheQuery(queryString, indexedQueryMode, this.keyTransformationHandler, this.timeoutExceptionFactory, asyncExecutor, classes);
        }
        catch (SearchException se) {
            throw new SearchException("'" + queryString + "' cannot be converted to an indexed query", (Throwable)se);
        }
    }

    @Override
    public <E> CacheQuery<E> getQuery(QueryDefinition queryDefinition, IndexedQueryMode indexedQueryMode, IndexedTypeMap<CustomTypeMetadata> indexedTypeMap) {
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        return this.queryEngine.buildCacheQuery(queryDefinition, indexedQueryMode, this.keyTransformationHandler, this.timeoutExceptionFactory, asyncExecutor, indexedTypeMap);
    }

    @Override
    public <E> CacheQuery<E> getQuery(Query luceneQuery, Class<?> ... classes) {
        return this.getQuery(luceneQuery, IndexedQueryMode.FETCH, classes);
    }

    public <E> CacheQuery<E> getQuery(HSQuery hSearchQuery, IndexedQueryMode queryMode) {
        if (this.timeoutExceptionFactory != null) {
            hSearchQuery.timeoutExceptionFactory(this.timeoutExceptionFactory);
        }
        Class[] classes = hSearchQuery.getTargetedEntities().toPojosSet().toArray(new Class[hSearchQuery.getTargetedEntities().size()]);
        this.queryInterceptor.enableClasses(classes);
        if (queryMode == IndexedQueryMode.BROADCAST) {
            ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
            return new ClusteredCacheQueryImpl(new QueryDefinition(hSearchQuery), asyncExecutor, this.cache, this.keyTransformationHandler, null);
        }
        return new CacheQueryImpl(hSearchQuery, this.cache, this.keyTransformationHandler);
    }

    @Override
    @Deprecated
    public <E> CacheQuery<E> getClusteredQuery(Query luceneQuery, Class<?> ... classes) {
        return this.getQuery(luceneQuery, IndexedQueryMode.BROADCAST, classes);
    }

    @Override
    public void registerKeyTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.keyTransformationHandler.registerTransformer(keyClass, transformerClass);
    }

    @Override
    public void setTimeoutExceptionFactory(TimeoutExceptionFactory timeoutExceptionFactory) {
        this.timeoutExceptionFactory = timeoutExceptionFactory;
    }

    @Override
    public EntityContext buildQueryBuilderForClass(Class<?> entityType) {
        this.queryInterceptor.enableClasses(entityType);
        return this.searchFactory.buildQueryBuilder().forEntity(entityType);
    }

    @Override
    public MassIndexer getMassIndexer() {
        return this.massIndexer;
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.searchFactory.getAnalyzer(name);
    }

    @Override
    public Statistics getStatistics() {
        return this.searchFactory.getStatistics();
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        PojoIndexedTypeIdentifier type = new PojoIndexedTypeIdentifier(clazz);
        return this.searchFactory.getAnalyzer((IndexedTypeIdentifier)type);
    }

    @Override
    public void purge(Class<?> entityType) {
        this.queryInterceptor.purgeIndex(entityType);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.isAssignableFrom(cls)) {
            return (T)this.searchFactory;
        }
        if (SearchManagerImplementor.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        throw new IllegalArgumentException("Cannot unwrap a SearchManagerImpl into a '" + cls.getName() + "'");
    }
}

