/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import org.hibernate.search.backend.spi.WorkType;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.CustomSearchWorkCreatorTest")
public class CustomSearchWorkCreatorTest
extends SingleCacheManagerTest {
    @Test
    public void testCustomWorkCreator() {
        SearchWorkCreator customSearchWorkCreator = (SearchWorkCreator)Mockito.spy((Object)SearchWorkCreator.DEFAULT);
        QueryInterceptor queryInterceptor = ComponentRegistryUtils.getQueryInterceptor((Cache)this.cache);
        queryInterceptor.setSearchWorkCreator(customSearchWorkCreator);
        KeyTransformationHandler keyTransformationHandler = queryInterceptor.getKeyTransformationHandler();
        Integer key = 1;
        Person value = new Person("john", "blurb", 30);
        this.cache.put((Object)key, (Object)value);
        ((SearchWorkCreator)Mockito.verify((Object)customSearchWorkCreator)).createPerEntityWork((Object)value, (Serializable)((Object)keyTransformationHandler.keyToString((Object)key)), WorkType.UPDATE);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().index(Index.ALL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }
}

