/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import java.util.Map;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.query.affinity.AffinityIndexManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.QueryParsingTest")
public class QueryParsingTest
extends AbstractInfinispanTest {
    public void testConfigurationFileParsing() throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configuration-parsing-test.xml");
        Map namedConfigurations = holder.getNamedConfigurationBuilders();
        Configuration defaultConfiguration = ((ConfigurationBuilder)namedConfigurations.get("default")).build();
        Assert.assertEquals((int)defaultConfiguration.indexing().properties().size(), (int)0);
        Assert.assertFalse((boolean)defaultConfiguration.indexing().index().isEnabled());
        Configuration simpleCfg = ((ConfigurationBuilder)namedConfigurations.get("simple")).build();
        Assert.assertFalse((boolean)simpleCfg.indexing().index().isEnabled());
        Assert.assertEquals((int)simpleCfg.indexing().properties().size(), (int)0);
        Configuration memoryCfg = ((ConfigurationBuilder)namedConfigurations.get("memory-searchable")).build();
        Assert.assertTrue((boolean)memoryCfg.indexing().index().isEnabled());
        Assert.assertEquals((int)2, (int)memoryCfg.indexing().properties().size());
        Assert.assertEquals((String)memoryCfg.indexing().properties().getProperty("default.directory_provider"), (String)"local-heap");
        Configuration diskCfg = ((ConfigurationBuilder)namedConfigurations.get("disk-searchable")).build();
        Assert.assertTrue((boolean)diskCfg.indexing().index().isEnabled());
        Assert.assertEquals((int)diskCfg.indexing().properties().size(), (int)3);
        Assert.assertEquals((String)diskCfg.indexing().properties().getProperty("hibernate.search.default.directory_provider"), (String)"filesystem");
        Assert.assertEquals((String)diskCfg.indexing().properties().getProperty("hibernate.search.cats.exclusive_index_use"), (String)"true");
        Configuration replDefaults = ((ConfigurationBuilder)namedConfigurations.get("repl-with-default")).build();
        Assert.assertTrue((boolean)replDefaults.indexing().index().isEnabled());
        Assert.assertFalse((boolean)replDefaults.indexing().properties().isEmpty());
        Configuration affinity = ((ConfigurationBuilder)namedConfigurations.get("dist-with-affinity")).build();
        Assert.assertTrue((boolean)affinity.indexing().index().isEnabled());
        Assert.assertEquals((Object)affinity.indexing().index(), (Object)Index.PRIMARY_OWNER);
        Assert.assertEquals((String)affinity.indexing().properties().getProperty("default.indexmanager"), (String)AffinityIndexManager.class.getName());
    }

    public void testConfigurationFileParsingWithDefaultEnabled() throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configuration-parsing-test-enbledInDefault.xml");
        Map namedConfigurations = holder.getNamedConfigurationBuilders();
        Configuration defaultConfiguration = ((ConfigurationBuilder)namedConfigurations.get("default")).build();
        Assert.assertEquals((int)defaultConfiguration.indexing().properties().size(), (int)2);
        Assert.assertTrue((boolean)defaultConfiguration.indexing().index().isEnabled());
        Assert.assertEquals((String)defaultConfiguration.indexing().properties().getProperty("hibernate.search.default.directory_provider"), (String)"someDefault");
        Configuration nonSearchableCfg = ((ConfigurationBuilder)namedConfigurations.get("not-searchable")).build();
        Assert.assertFalse((boolean)nonSearchableCfg.indexing().index().isEnabled());
        Configuration simpleCfg = ((ConfigurationBuilder)namedConfigurations.get("simple")).build();
        Assert.assertTrue((boolean)simpleCfg.indexing().index().isEnabled());
        Assert.assertEquals((int)simpleCfg.indexing().properties().size(), (int)2);
        Configuration memoryCfg = ((ConfigurationBuilder)namedConfigurations.get("memory-searchable")).build();
        Assert.assertTrue((boolean)memoryCfg.indexing().index().isEnabled());
        Assert.assertEquals((Object)memoryCfg.indexing().index(), (Object)Index.ALL);
        Assert.assertEquals((int)memoryCfg.indexing().properties().size(), (int)2);
        Assert.assertEquals((String)memoryCfg.indexing().properties().getProperty("hibernate.search.default.directory_provider"), (String)"local-heap");
        Configuration diskCfg = ((ConfigurationBuilder)namedConfigurations.get("disk-searchable")).build();
        Assert.assertTrue((boolean)diskCfg.indexing().index().isEnabled());
        Assert.assertEquals((Object)diskCfg.indexing().index(), (Object)Index.PRIMARY_OWNER);
        Assert.assertEquals((int)diskCfg.indexing().properties().size(), (int)3);
        Assert.assertEquals((String)diskCfg.indexing().properties().getProperty("hibernate.search.default.directory_provider"), (String)"filesystem");
        Assert.assertEquals((String)diskCfg.indexing().properties().getProperty("hibernate.search.cats.exclusive_index_use"), (String)"true");
    }
}

