/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.api.NotIndexedType;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.query.queries.faceting.Car;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MassIndexingTest")
public class MassIndexingTest
extends DistributedMassIndexingTest {
    @Override
    public void testReindexing() throws Exception {
        for (int i = 0; i < 200; ++i) {
            ((Cache)this.caches.get(i % 2)).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put(this.key("F" + i + "NUM"), (Object)new Car(i % 2 == 0 ? "megane" : "bmw", "blue", 300 + i));
        }
        ((Cache)this.caches.get(0)).getAdvancedCache().put(this.key("FNonIndexed1NUM"), (Object)new NotIndexedType("test1"));
        ((Cache)this.caches.get(0)).getAdvancedCache().put(this.key("FNonIndexed2NUM"), (Object)new NotIndexedType("test2"));
        this.verifyFindsCar(0, "megane");
        this.verifyFindsCar(0, "test1");
        this.verifyFindsCar(0, "test2");
        ((Cache)this.caches.get(0)).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put(this.key("FNonIndexed3NUM"), (Object)new NotIndexedType("test3"));
        this.verifyFindsCar(0, "test3");
        this.rebuildIndexes();
        this.verifyFindsCar(100, "megane");
        this.verifyFindsCar(0, "test1");
        this.verifyFindsCar(0, "test2");
    }

    public void testOverlappingMassIndexers() {
        Cache cache = (Cache)this.caches.get(0);
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        MassIndexer massIndexer = searchManager.getMassIndexer();
        IntStream.range(0, 300).forEach(i -> cache.put((Object)i, (Object)new Car("whatever", "whatever", 0)));
        CompletableFuture first = massIndexer.startAsync();
        this.eventually(() -> ((MassIndexer)massIndexer).isRunning());
        CompletableFuture second = massIndexer.startAsync();
        this.assertSuccessCompletion(first);
        this.assertErrorCompletion(second, MassIndexerAlreadyStartedException.class);
        this.eventually(() -> !massIndexer.isRunning());
        CompletableFuture third = massIndexer.startAsync();
        this.assertSuccessCompletion(third);
    }

    private void assertSuccessCompletion(CompletableFuture<Void> future) {
        try {
            FunctionalTestUtils.await(future);
        }
        catch (Exception e) {
            Assert.fail((String)"Future should've completed successfully");
        }
    }

    private void assertErrorCompletion(CompletableFuture<Void> future, Class<? extends Throwable> expected) {
        try {
            FunctionalTestUtils.await(future);
            Assert.fail((String)"Future should've thrown an error");
        }
        catch (Error e) {
            Assert.assertEquals(Util.getRootCause((Throwable)e).getClass(), expected);
        }
    }

    @Override
    protected void rebuildIndexes() throws Exception {
        Cache cache = (Cache)this.caches.get(0);
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        CompletableFuture future = searchManager.getMassIndexer().startAsync();
        future.get();
    }
}

