/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.analysis.Team;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.analysis.AnalyzerTest")
public class AnalyzerTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(Team.class).addProperty("hibernate.search.default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testAnalyzerDef() throws Exception {
        Team team = new Team();
        team.setDescription("This is a D\u00e0scription");
        team.setLocation("Atlanta");
        team.setName("ATL team");
        this.cache.put((Object)"id", (Object)team);
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        TermQuery query = new TermQuery(new Term("description", "D\u00e0scription"));
        AssertJUnit.assertEquals((String)"iso latin filter should work.  \ufffd should be a now", (int)0, (int)searchManager.getQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "is"));
        AssertJUnit.assertEquals((String)"stop word filter should work. is should be removed", (int)0, (int)searchManager.getQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "dascript"));
        AssertJUnit.assertEquals((String)"snowball stemmer should work. 'dascription' should be stemmed to 'dascript'", (int)1, (int)searchManager.getQuery((Query)query, new Class[0]).list().size());
    }

    public void testAnalyzers() throws Exception {
        SearchManager search = Search.getSearchManager((Cache)this.cache);
        Analyzer analyzer = search.getAnalyzer("standard_analyzer");
        String text = "This is just FOOBAR's";
        AssertJUnit.assertEquals(Arrays.asList("This", "is", "just", "FOOBAR's"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("html_standard_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        AssertJUnit.assertEquals(Arrays.asList("This", "is", "foobar's"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("html_whitespace_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        AssertJUnit.assertEquals(Arrays.asList("This", "is", "foobar's"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        AssertJUnit.assertEquals(Arrays.asList("abc", "abcd", "abcde"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        AssertJUnit.assertEquals(Arrays.asList("abc", "abcd", "abcde"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("porter_analyzer");
        text = "bikes bikes biking";
        AssertJUnit.assertEquals(Arrays.asList("bike", "bike", "bike"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("word_analyzer");
        text = "CamelCase";
        AssertJUnit.assertEquals(Arrays.asList("Camel", "Case"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("synonym_analyzer");
        text = "ipod cosmos";
        AssertJUnit.assertEquals(Arrays.asList("ipod", "i-pod", "cosmos", "universe"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("shingle_analyzer");
        text = "please divide this sentence into shingles";
        AssertJUnit.assertEquals(Arrays.asList("please", "please divide", "divide", "divide this", "this", "this sentence", "sentence", "sentence into", "into", "into shingles", "shingles"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("pattern_analyzer");
        text = "foo,bar";
        AssertJUnit.assertEquals(Arrays.asList("foo", "bar"), this.terms(analyzer, "name", text));
        analyzer = search.getAnalyzer("mapping_char_analyzer");
        text = "CORA\u00c7\u00c3O DE MEL\u00c3O";
        AssertJUnit.assertEquals(Arrays.asList("CORACAO", "DE", "MELAO"), this.terms(analyzer, "name", text));
    }

    private List<String> terms(Analyzer analyzer, String fieldName, String text) throws IOException {
        ArrayList<String> terms = new ArrayList<String>();
        TokenStream tokenStream = analyzer.tokenStream(fieldName, text);
        tokenStream.addAttribute(CharTermAttribute.class);
        CharTermAttribute attribute = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
        tokenStream.reset();
        while (tokenStream.incrementToken()) {
            terms.add(attribute.toString());
        }
        tokenStream.close();
        return terms;
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Team.class};
    }
}

