/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.CyclicDependencyException;
import org.infinispan.util.DependencyGraph;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.IndexCacheStopTest")
public class IndexCacheStopTest
extends AbstractInfinispanTest {
    private static final int CACHE_SIZE = 10;

    @Test
    public void testIndexingOnDefaultCache() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.getIndexedConfig());
        this.startAndIndexData(null, (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingOnNamedCache() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.getIndexedConfig());
        cacheManager.defineConfiguration("custom", cacheManager.getDefaultCacheConfiguration());
        this.startAndIndexData("custom", (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingOnMultipleCaches() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        cacheManager.defineConfiguration("cache1", this.getIndexedConfig().build());
        cacheManager.defineConfiguration("cache2", this.getIndexedConfigWithCustomCaches("lockCache", "metadataCache", "dataCache").build());
        this.startAndIndexData("cache1", (CacheContainer)cacheManager);
        this.startAndIndexData("cache2", (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingWithInfinispanIndexManager() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        cacheManager.defineConfiguration("cache", this.getIndexedConfigWithInfinispanIndexManager().build());
        this.startAndIndexData("cache", (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingWithCustomLock() throws CyclicDependencyException {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        DependencyGraph graph = (DependencyGraph)TestingUtil.extractField((Object)cacheManager, (String)"cacheDependencyGraph");
        cacheManager.defineConfiguration("cache", this.getIndexedConfigWithCustomLock().build());
        this.startAndIndexData("cache", (CacheContainer)cacheManager);
        cacheManager.stop();
        List cacheOrder = graph.topologicalSort();
        Assert.assertTrue((cacheOrder.indexOf("cache") < cacheOrder.indexOf("LuceneIndexesData") ? 1 : 0) != 0);
        Assert.assertTrue((cacheOrder.indexOf("cache") < cacheOrder.indexOf("LuceneIndexesMetadata") ? 1 : 0) != 0);
        Assert.assertTrue((cacheOrder.indexOf("cache") < cacheOrder.indexOf("LuceneIndexesLocking") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingOnCacheItself() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        cacheManager.defineConfiguration("single", this.getIndexedConfigWithCustomCaches("single", "single", "single").build());
        this.startAndIndexData("single", (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingWithUserCacheAsDataCache() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        cacheManager.defineConfiguration("single", this.getIndexedConfigWithCustomCaches("locking", "metadata", "single").build());
        this.startAndIndexData("single", (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingMultipleDirectoriesOnSameCache() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        cacheManager.defineConfiguration("cacheA", this.getIndexedConfigWithCustomCaches("single", "single", "single").build());
        cacheManager.defineConfiguration("cacheB", this.getIndexedConfigWithCustomCaches("single", "single", "single").build());
        this.startAndIndexData("cacheA", (CacheContainer)cacheManager);
        this.startAndIndexOtherEntityData("cacheB", (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testIndexingHierarchically() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        cacheManager.defineConfiguration("cacheC", this.getIndexedConfigWithCustomCaches("cacheB", "cacheB", "cacheB").build());
        cacheManager.defineConfiguration("cacheB", this.getIndexedConfigWithCustomCaches("cacheA", "cacheA", "cacheA").build());
        cacheManager.defineConfiguration("cacheA", this.getIndexedConfig().build());
        this.startAndIndexData("cacheA", (CacheContainer)cacheManager);
        this.startAndIndexData("cacheB", (CacheContainer)cacheManager);
        this.startAndIndexData("cacheC", (CacheContainer)cacheManager);
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    @Test
    public void testStartAndStopWithEmptyCache() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.getIndexedConfig());
        cacheManager.getCache();
        cacheManager.stop();
        AssertJUnit.assertEquals((Object)cacheManager.getStatus(), (Object)ComponentStatus.TERMINATED);
    }

    private void startAndIndexData(String cacheName, CacheContainer cacheContainer) {
        this.startAndIndexEntityData(cacheName, cacheContainer, i -> new Person("name" + i, "blurb" + i, (int)i), Person.class);
    }

    private void startAndIndexOtherEntityData(String cacheName, CacheContainer cacheContainer) {
        this.startAndIndexEntityData(cacheName, cacheContainer, i -> new AnotherGrassEater("name" + i, "blurb" + i), AnotherGrassEater.class);
    }

    private <T> void startAndIndexEntityData(String cacheName, CacheContainer cacheContainer, Function<Integer, T> provider, Class<T> type) {
        Cache cache = cacheName == null ? cacheContainer.getCache() : cacheContainer.getCache(cacheName);
        this.populateData(cache, provider);
        this.assertIndexPopulated(cache, type);
    }

    private <T> void assertIndexPopulated(Cache<Integer, T> cache, Class<T> clazz) {
        CacheQuery query = Search.getSearchManager(cache).getQuery((Query)new MatchAllDocsQuery(), new Class[]{clazz});
        AssertJUnit.assertEquals((int)query.list().size(), (int)10);
    }

    private <T> void populateData(Cache<Integer, T> cache, Function<Integer, T> provider) {
        IntStream.range(0, 10).forEach(i -> cache.put((Object)i, provider.apply(i)));
    }

    private ConfigurationBuilder getBaseConfig() {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        cfg.clustering().cacheMode(CacheMode.DIST_SYNC).transaction().transactionMode(TransactionMode.TRANSACTIONAL).recovery().disable().locking().lockAcquisitionTimeout(10000L);
        return cfg;
    }

    private ConfigurationBuilder getIndexedConfig() {
        ConfigurationBuilder cfg = this.getBaseConfig();
        cfg.indexing().index(Index.ALL).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("default.directory_provider", "infinispan").addProperty("lucene_version", "LUCENE_CURRENT");
        return cfg;
    }

    private ConfigurationBuilder getIndexedConfigWithCustomCaches(String lockCache, String metadataCache, String dataCache) {
        ConfigurationBuilder cfg = this.getIndexedConfig();
        cfg.indexing().addProperty("default.locking_cachename", lockCache).addProperty("default.data_cachename", dataCache).addProperty("default.metadata_cachename", metadataCache);
        return cfg;
    }

    private ConfigurationBuilder getIndexedConfigWithInfinispanIndexManager() {
        ConfigurationBuilder cfg = this.getIndexedConfig();
        cfg.indexing().addProperty("default.indexmanager", InfinispanIndexManager.class.getName());
        return cfg;
    }

    private ConfigurationBuilder getIndexedConfigWithCustomLock() {
        ConfigurationBuilder cfg = this.getIndexedConfig();
        cfg.indexing().addProperty("default.locking_strategy", "none");
        return cfg;
    }
}

