/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.lucene.queryparser.classic.ParseException;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.MultipleCachesTest")
public class MultipleCachesTest
extends SingleCacheManagerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm;
        String config = TestingUtil.wrapXMLWithSchema((String)"<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <indexing index=\"NONE\" />\n   </local-cache>\n   <local-cache name=\"indexingenabled\">\n      <indexing index=\"LOCAL\" >\n         <indexed-entities>\n            <indexed-entity>org.infinispan.query.test.Person</indexed-entity>\n         </indexed-entities>\n         <property name=\"default.directory_provider\">local-heap</property>\n         <property name=\"lucene_version\">LUCENE_CURRENT</property>\n      </indexing>\n   </local-cache>\n</cache-container>");
        this.log.tracef("Using test configuration:\n%s", (Object)config);
        try (ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());){
            cm = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        this.cache = cm.getCache();
        return cm;
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void queryNotIndexedCache() throws ParseException {
        this.cacheManager.defineConfiguration("notIndexedA", this.cacheManager.getDefaultCacheConfiguration());
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedA");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(this.cache, "name", "Name");
        AssertJUnit.assertEquals((int)1, (int)cq.getResultSize());
        List l = cq.list();
        AssertJUnit.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        AssertJUnit.assertEquals((String)"A Person's Name", (String)p.getName());
        AssertJUnit.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        AssertJUnit.assertEquals((int)75, (int)p.getAge());
    }

    @Test
    public void notIndexedCacheNormalUse() {
        this.cacheManager.defineConfiguration("notIndexedB", this.cacheManager.getDefaultCacheConfiguration());
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedB");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        assert (notIndexedCache.get((Object)"1") != null);
    }

    @Test
    public void indexedCache() throws ParseException {
        Cache indexedCache = this.cacheManager.getCache("indexingenabled");
        this.useQuery((Cache<Object, Object>)indexedCache);
    }

    private void useQuery(Cache<Object, Object> indexedCache) throws ParseException {
        indexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(indexedCache, "name", "Name");
        AssertJUnit.assertEquals((int)1, (int)cq.getResultSize());
        List l = cq.list();
        AssertJUnit.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        AssertJUnit.assertEquals((String)"A Person's Name", (String)p.getName());
        AssertJUnit.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        AssertJUnit.assertEquals((int)75, (int)p.getAge());
        SearchManager queryFactory = Search.getSearchManager(indexedCache);
        SearchIntegrator searchImpl = (SearchIntegrator)queryFactory.unwrap(SearchIntegrator.class);
        Set indexManagers = ((EntityIndexBinding)searchImpl.getIndexBindings().get(Person.class)).getIndexManagerSelector().all();
        assert (indexManagers != null && indexManagers.size() == 1);
        DirectoryBasedIndexManager directory = (DirectoryBasedIndexManager)indexManagers.iterator().next();
        DirectoryProvider directoryProvider = directory.getDirectoryProvider();
        assert (directoryProvider instanceof RAMDirectoryProvider) : "configuration properties where ignored";
    }
}

