/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.jmx;

import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.jmx.QueryMBeanTest")
public class QueryMBeanTest
extends SingleCacheManagerTest {
    private static final String TEST_JMX_DOMAIN = QueryMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private static final String CACHE_NAME = "queryable-cache";
    private static final int numberOfEntries = 100;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalConfiguration.globalJmxStatistics().enable().jmxDomain(TEST_JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.jmxStatistics().enabled(true).indexing().index(Index.ALL).addIndexedEntities(new Class[]{Person.class, AnotherGrassEater.class}).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT");
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalConfiguration, (ConfigurationBuilder)builder);
        cm.defineConfiguration(CACHE_NAME, builder.build());
        return cm;
    }

    public void testQueryStatsMBean() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName name = this.getQueryStatsObjectName(TEST_JMX_DOMAIN, CACHE_NAME);
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(name));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(name, "StatisticsEnabled")));
        mBeanServer.setAttribute(name, new Attribute("StatisticsEnabled", true));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(name, "StatisticsEnabled")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryStats() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName name = this.getQueryStatsObjectName(TEST_JMX_DOMAIN, CACHE_NAME);
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        try {
            AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(name));
            if (!((Boolean)mBeanServer.getAttribute(name, "StatisticsEnabled")).booleanValue()) {
                mBeanServer.setAttribute(name, new Attribute("StatisticsEnabled", true));
            }
            Cache cache = this.cacheManager.getCache(CACHE_NAME);
            SearchManager searchManager = Search.getSearchManager((Cache)cache);
            AssertJUnit.assertTrue((boolean)searchManager.getStatistics().isStatisticsEnabled());
            for (int i = 0; i < 100; ++i) {
                Person person = new Person();
                person.setName("key" + i);
                person.setAge(i);
                person.setBlurb("value " + i);
                person.setNonIndexedField("i: " + i);
                cache.put((Object)person.getName(), (Object)person);
            }
            AssertJUnit.assertTrue((boolean)searchManager.getStatistics().isStatisticsEnabled());
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionCount"));
            QueryParser queryParser = TestQueryHelperFactory.createQueryParser("blurb");
            Query luceneQuery = queryParser.parse("value");
            CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[0]);
            List found = cacheQuery.list();
            AssertJUnit.assertEquals((Object)1L, (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionCount"));
            AssertJUnit.assertEquals((int)100, (int)found.size());
            AssertJUnit.assertEquals((Object)100, (Object)mBeanServer.invoke(name, "getNumberOfIndexedEntities", new Object[]{Person.class.getName()}, new String[]{String.class.getName()}));
            AssertJUnit.assertEquals((int)2, (int)searchManager.getStatistics().indexedEntitiesCount().size());
            AnotherGrassEater anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
            cache.put((Object)"key101", (Object)anotherGrassEater);
            cacheQuery = searchManager.getQuery(luceneQuery, new Class[0]);
            found = cacheQuery.list();
            AssertJUnit.assertEquals((int)100, (int)found.size());
            AssertJUnit.assertEquals((Object)1, (Object)mBeanServer.invoke(name, "getNumberOfIndexedEntities", new Object[]{AnotherGrassEater.class.getName()}, new String[]{String.class.getName()}));
            Set classNames = (Set)mBeanServer.getAttribute(name, "IndexedClassNames");
            AssertJUnit.assertEquals((int)2, (int)classNames.size());
            AssertJUnit.assertTrue((String)"The set should contain the Person class name.", (boolean)classNames.contains(Person.class.getName()));
            AssertJUnit.assertTrue((String)"The set should contain the AnotherGrassEater class name.", (boolean)classNames.contains(AnotherGrassEater.class.getName()));
            AssertJUnit.assertEquals((int)2, (int)searchManager.getStatistics().indexedEntitiesCount().size());
            AssertJUnit.assertTrue((String)"The query execution total time should be > 0.", ((Long)mBeanServer.getAttribute(name, "SearchQueryTotalTime") > 0L ? 1 : 0) != 0);
            AssertJUnit.assertEquals((Object)2L, (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionCount"));
            AssertJUnit.assertEquals((Object)"blurb:value", (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionMaxTimeQueryString"));
            AssertJUnit.assertTrue(((Long)mBeanServer.getAttribute(name, "SearchQueryExecutionMaxTime") > 0L ? 1 : 0) != 0);
            AssertJUnit.assertTrue(((Long)mBeanServer.getAttribute(name, "SearchQueryExecutionAvgTime") > 0L ? 1 : 0) != 0);
            mBeanServer.invoke(name, "clear", new Object[0], new String[0]);
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionCount"));
            AssertJUnit.assertEquals((Object)"", (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionMaxTimeQueryString"));
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionMaxTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "SearchQueryExecutionAvgTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "ObjectsLoadedCount"));
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "ObjectLoadingTotalTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "ObjectLoadingExecutionMaxTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(name, "ObjectLoadingExecutionAvgTime"));
        }
        finally {
            mBeanServer.setAttribute(name, new Attribute("StatisticsEnabled", false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJmxUnregistration() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName queryStatsObjectName = this.getQueryStatsObjectName(TEST_JMX_DOMAIN, CACHE_NAME);
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        Set<ObjectName> matchingNames = mBeanServer.queryNames(new ObjectName(TEST_JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
        AssertJUnit.assertEquals((int)1, (int)matchingNames.size());
        AssertJUnit.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
        EmbeddedCacheManager cm2 = null;
        try {
            GlobalConfigurationBuilder globalConfig2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
            globalConfig2.cacheManagerName("cm2");
            TestCacheManagerFactory.configureGlobalJmx((GlobalConfigurationBuilder)globalConfig2, (String)TEST_JMX_DOMAIN, (MBeanServerLookup)this.mBeanServerLookup);
            ConfigurationBuilder defaultCacheConfig2 = new ConfigurationBuilder();
            defaultCacheConfig2.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT").jmxStatistics().enable();
            cm2 = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalConfig2, (ConfigurationBuilder)defaultCacheConfig2);
            cm2.defineConfiguration(CACHE_NAME, defaultCacheConfig2.build());
            cm2.getCache(CACHE_NAME);
            matchingNames = mBeanServer.queryNames(new ObjectName(TEST_JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
            AssertJUnit.assertEquals((int)2, (int)matchingNames.size());
            AssertJUnit.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm2});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm2});
        matchingNames = mBeanServer.queryNames(new ObjectName(TEST_JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
        AssertJUnit.assertEquals((int)1, (int)matchingNames.size());
        AssertJUnit.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
    }

    private ObjectName getQueryStatsObjectName(String jmxDomain, String cacheName) {
        String cacheManagerName = this.cacheManager.getCacheManagerConfiguration().cacheManagerName();
        try {
            return new ObjectName(jmxDomain + ":type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName) + ",component=Statistics");
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Malformed object name", (Throwable)e);
        }
    }
}

