/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.NonIndexedQueryDslConditionsTest")
public class NonIndexedQueryDslConditionsTest
extends QueryDslConditionsTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        this.createClusteredCaches(1, QueryTestSCI.INSTANCE, cfg);
    }

    public void testInsertAndIterateInTx() throws Exception {
        User newUser = this.getModelFactory().makeUser();
        newUser.setId(15);
        newUser.setName("Test");
        newUser.setSurname("User");
        newUser.setGender(User.Gender.MALE);
        newUser.setAge(20);
        List results = (List)TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            Query q = this.getQueryFactory().from(this.getModelFactory().getUserImplClass()).not().having("age").eq((Object)20).build();
            this.cache(0).put((Object)("new_user_" + newUser.getId()), (Object)newUser);
            return q.list();
        });
        this.cache(0).remove((Object)("new_user_" + newUser.getId()));
        AssertJUnit.assertEquals((int)3, (int)results.size());
    }

    @Override
    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Indexing was not enabled on cache.*")
    public void testIndexPresence() {
        Search.getSearchManager((Cache)((Cache)this.getCacheForQuery()));
    }

    public void testAnd5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").lt((Object)1000).and().having("age").lt((Object)1000).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    @Override
    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028521: Full-text queries cannot be applied to property 'longDescription' in type org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS unless the property is indexed and analyzed.")
    public void testFullTextTerm() {
        super.testFullTextTerm();
    }

    @Override
    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028521: Full-text queries cannot be applied to property 'longDescription' in type org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS unless the property is indexed and analyzed.")
    public void testFullTextPhrase() {
        super.testFullTextPhrase();
    }
}

