/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIteratorTest;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.impl.QueryResultLoader;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.LazyIteratorTest")
public class LazyIteratorTest
extends EagerIteratorTest {
    private DocumentExtractor extractor;

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.extractor = (DocumentExtractor)Mockito.mock(DocumentExtractor.class);
        Mockito.when((Object)this.extractor.getMaxIndex()).thenReturn((Object)(this.entityInfos.size() - 1));
        Mockito.when((Object)this.extractor.extract(Matchers.anyInt())).thenAnswer(invocation -> {
            int index = (Integer)invocation.getArguments()[0];
            return (EntityInfo)this.entityInfos.get(index);
        });
        this.iterator = new LazyIterator(this.extractor, (QueryResultLoader)new EntityLoader(this.cache, new KeyTransformationHandler(null)), this.getFetchSize());
    }

    @Override
    @AfterMethod(alwaysRun=false)
    public void tearDown() {
        this.iterator.close();
        ((DocumentExtractor)Mockito.verify((Object)this.extractor)).close();
        super.tearDown();
    }
}

