/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.AdvancedCache;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.impl.QueryResultLoader;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.VeryLargeFetchSizeTest")
public class VeryLargeFetchSizeTest {
    private static final int VERY_LARGE_FETCH_SIZE = Integer.MAX_VALUE;
    private List<EntityInfo> entityInfos = new ArrayList<EntityInfo>();
    private AdvancedCache<String, String> cache;

    @Test
    public void testLazyIteratorHandlesVeryLargeFetchSize() {
        this.cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        DocumentExtractor extractor = (DocumentExtractor)Mockito.mock(DocumentExtractor.class);
        new LazyIterator(extractor, (QueryResultLoader)new EntityLoader(this.cache, new KeyTransformationHandler(null)), Integer.MAX_VALUE);
    }

    @Test
    public void testEagerIteratorHandlesVeryLargeFetchSize() {
        this.cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        new EagerIterator(this.entityInfos, (QueryResultLoader)new EntityLoader(this.cache, new KeyTransformationHandler(null)), Integer.MAX_VALUE);
    }
}

