/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Date;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.backend.impl.lucene.works.ByTermUpdateWorkExecutor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.Bond;
import org.infinispan.query.backend.Debenture;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.MultipleEntitiesTest")
public class MultipleEntitiesTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().index(Index.ALL).addIndexedEntity(Bond.class).addIndexedEntity(Debenture.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @Test
    public void testIndexAndQuery() {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        this.cache.put((Object)123405, (Object)new Bond(new Date(System.currentTimeMillis()), 450L));
        this.assertEfficientIndexingUsed((SearchIntegrator)searchManager.unwrap(SearchIntegrator.class), Bond.class);
        this.cache.put((Object)123502, (Object)new Debenture("GB", 116.0));
        this.assertEfficientIndexingUsed((SearchIntegrator)searchManager.unwrap(SearchIntegrator.class), Debenture.class);
        this.cache.put((Object)223456, (Object)new Bond(new Date(System.currentTimeMillis()), 550L));
        this.assertEfficientIndexingUsed((SearchIntegrator)searchManager.unwrap(SearchIntegrator.class), Bond.class);
        CacheQuery query = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Bond.class, Debenture.class});
        Assert.assertEquals((int)query.list().size(), (int)3);
        CacheQuery queryBond = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Bond.class});
        Assert.assertEquals((int)queryBond.getResultSize(), (int)2);
        CacheQuery queryDeb = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Debenture.class});
        Assert.assertEquals((int)queryDeb.getResultSize(), (int)1);
    }

    private void assertEfficientIndexingUsed(SearchIntegrator searchIntegrator, Class<?> clazz) {
        DirectoryBasedIndexManager im = (DirectoryBasedIndexManager)((EntityIndexBinding)searchIntegrator.getIndexBindings().get(clazz)).getIndexManagerSelector().all().iterator().next();
        WorkspaceHolder workspaceHolder = im.getWorkspaceHolder();
        LuceneBackendResources indexResources = workspaceHolder.getIndexResources();
        IndexWorkVisitor visitor = indexResources.getWorkVisitor();
        Assert.assertTrue((boolean)(TestingUtil.extractField((Object)visitor, (String)"updateExecutor") instanceof ByTermUpdateWorkExecutor));
    }
}

