/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.testdomain.hsearch;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.impl.BuiltinIterableBridge;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AddressHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserBase;

@Indexed
public class UserHS
extends UserBase {
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    private int id;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @FieldBridge(impl=BuiltinIterableBridge.class)
    private Set<Integer> accountIds;
    @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
    @SortableField
    private String surname;
    @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
    private String salutation;
    @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="-1")
    @NumericField
    @SortableField
    private Integer age;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private User.Gender gender;
    @IndexedEmbedded(targetElement=AddressHS.class)
    private List<Address> addresses;
    @Field(analyze=Analyze.NO, store=Store.YES, index=Index.YES)
    private Instant creationDate;
    private Instant passwordExpirationDate;
    private String notes;

    @Override
    @ProtoField(number=2, defaultValue="0")
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    @ProtoField(number=3, collectionImplementation=HashSet.class)
    public Set<Integer> getAccountIds() {
        return this.accountIds;
    }

    @Override
    public void setAccountIds(Set<Integer> accountIds) {
        this.accountIds = accountIds;
    }

    @Override
    @ProtoField(number=4)
    public String getSurname() {
        return this.surname;
    }

    @Override
    public void setSurname(String surname) {
        this.surname = surname;
    }

    @Override
    @ProtoField(number=5)
    public String getSalutation() {
        return this.salutation;
    }

    @Override
    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    @Override
    @ProtoField(number=6)
    public Integer getAge() {
        return this.age;
    }

    @Override
    public void setAge(Integer age) {
        this.age = age;
    }

    @Override
    @ProtoField(number=7)
    public User.Gender getGender() {
        return this.gender;
    }

    @Override
    public void setGender(User.Gender gender) {
        this.gender = gender;
    }

    @Override
    public List<Address> getAddresses() {
        return this.addresses;
    }

    @Override
    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    @ProtoField(number=8, collectionImplementation=ArrayList.class)
    List<AddressHS> getHSAddresses() {
        return this.addresses == null ? null : this.addresses.stream().map(AddressHS.class::cast).collect(Collectors.toList());
    }

    void setHSAddresses(List<AddressHS> addresses) {
        this.addresses = addresses == null || addresses.isEmpty() ? null : new ArrayList<AddressHS>(addresses);
    }

    @Override
    @ProtoField(number=9)
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    @ProtoField(number=10)
    public Instant getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Instant creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    @ProtoField(number=11)
    public Instant getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    @Override
    public void setPasswordExpirationDate(Instant passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserHS other = (UserHS)o;
        if (this.age != null ? !this.age.equals(other.age) : other.age != null) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.accountIds != null ? !this.accountIds.equals(other.accountIds) : other.accountIds != null) {
            return false;
        }
        if (this.addresses != null ? !this.addresses.equals(other.addresses) : other.addresses != null) {
            return false;
        }
        if (this.gender != other.gender) {
            return false;
        }
        if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
            return false;
        }
        if (this.surname != null ? !this.surname.equals(other.surname) : other.surname != null) {
            return false;
        }
        if (this.salutation != null ? !this.salutation.equals(other.salutation) : other.salutation != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(other.notes) : other.notes != null) {
            return false;
        }
        if (this.creationDate != null ? !this.creationDate.equals(other.creationDate) : other.creationDate != null) {
            return false;
        }
        return !(this.passwordExpirationDate != null ? !this.passwordExpirationDate.equals(other.passwordExpirationDate) : other.passwordExpirationDate != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.accountIds != null ? this.accountIds.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.surname != null ? this.surname.hashCode() : 0);
        result = 31 * result + (this.salutation != null ? this.salutation.hashCode() : 0);
        result = 31 * result + (this.age != null ? this.age : 0);
        result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
        result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 31 * result + (this.passwordExpirationDate != null ? this.passwordExpirationDate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UserHS{id=" + this.id + ", name='" + this.name + '\'' + ", surname='" + this.surname + '\'' + ", salutation='" + this.salutation + '\'' + ", accountIds=" + this.accountIds + ", addresses=" + this.addresses + ", age=" + this.age + ", gender=" + (Object)((Object)this.gender) + ", notes=" + this.notes + ", creationDate='" + this.creationDate + '\'' + ", passwordExpirationDate=" + this.passwordExpirationDate + '}';
    }
}

