/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexedembedded;

import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.indexedembedded.City;
import org.infinispan.query.indexedembedded.Country;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.indexedembedded.CollectionsIndexingTest")
public class CollectionsIndexingTest
extends SingleCacheManagerTest {
    private SearchManager searchManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(Country.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @BeforeClass
    public void prepareSearchManager() {
        this.searchManager = Search.getSearchManager((Cache)this.cache);
    }

    @AfterMethod
    public void cleanupData() {
        this.cache.clear();
    }

    @Test
    public void searchOnEmptyIndex() throws Exception {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");
        Query query = queryParser.parse("Italy");
        List list = this.searchManager.getQuery(query, new Class[]{Country.class, City.class}).list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void searchOnAllTypes() throws Exception {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");
        Query query = queryParser.parse("Italy");
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        List list = this.searchManager.getQuery(query, new Class[]{Country.class, City.class}).list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        list = this.searchManager.getQuery(query, new Class[0]).list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        list = this.searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void searchOnSimpleField() throws Exception {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");
        Query query = queryParser.parse("Italy");
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        List list = this.searchManager.getQuery(query, new Class[]{Country.class, City.class}).list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void searchOnEmbeddedField() throws Exception {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("cities.name");
        Query query = queryParser.parse("Newcastle");
        Country uk = new Country();
        City london = new City();
        london.name = "London";
        City newcastle = new City();
        newcastle.name = "Newcastle";
        uk.countryName = "United Kingdom";
        uk.cities.add(newcastle);
        uk.cities.add(london);
        this.cache.put((Object)"UK", (Object)uk);
        this.cache.put((Object)"UK", (Object)uk);
        this.cache.put((Object)"UK", (Object)uk);
        List list = this.searchManager.getQuery(query, new Class[]{Country.class, City.class}).list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertSame((Object)uk, list.get(0));
    }
}

