/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.transaction.TransactionManager;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.spi.SearchManagerImplementor;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.function.SerializableBiFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredCacheTest")
public class ClusteredCacheTest
extends MultipleCacheManagersTest {
    protected Cache<Object, Person> cache1;
    protected Cache<Object, Person> cache2;
    private Person person1;
    private Person person2;
    private Person person3;
    private Person person4;
    private QueryParser queryParser;
    private Query luceneQuery;
    private CacheQuery<Person> cacheQuery;
    private final String key1 = "Navin";
    private final String key2 = "BigGoat";
    private final String key3 = "MiniGoat";

    public ClusteredCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public Object[] factory() {
        return new Object[]{new ClusteredCacheTest().storageType(StorageType.OFF_HEAP), new ClusteredCacheTest().storageType(StorageType.BINARY), new ClusteredCacheTest().storageType(StorageType.OBJECT)};
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        this.cache(0).clear();
        super.clearContent();
    }

    protected void enhanceConfig(ConfigurationBuilder cacheCfg) {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)this.transactionsEnabled());
        cacheCfg.indexing().index(Index.ALL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        cacheCfg.memory().storageType(this.storageType);
        this.enhanceConfig(cacheCfg);
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, cacheCfg);
        this.cache1 = this.cache(0);
        this.cache2 = this.cache(1);
    }

    private void prepareTestedObjects() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(30);
        this.person2 = new Person();
        this.person2.setName("BigGoat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(22);
        this.person3 = new Person();
        this.person3.setName("MiniGoat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(15);
    }

    protected void prepareTestData() throws Exception {
        this.prepareTestedObjects();
        TransactionManager transactionManager = this.cache1.getAdvancedCache().getTransactionManager();
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache1.put((Object)"Navin", (Object)this.person1);
        this.cache1.put((Object)"BigGoat", (Object)this.person2);
        this.cache1.put((Object)"MiniGoat", (Object)this.person3);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    protected boolean transactionsEnabled() {
        return false;
    }

    public void testSimple() throws Exception {
        this.prepareTestData();
        this.cacheQuery = this.createCacheQuery("blurb:playing");
        List found = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        if (found.get(0) == null) {
            this.log.warn((Object)"found.get(0) is null");
            Person p1 = (Person)this.cache2.get((Object)"Navin");
            if (p1 == null) {
                this.log.warn((Object)"Person p1 is null in sc2 and cannot actually see the data of person1 in sc1");
            } else {
                this.log.trace((Object)("p1 name is  " + p1.getName()));
            }
        }
        AssertJUnit.assertEquals((Object)this.person1, found.get(0));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    private void assertQueryInterceptorPresent(Cache<?, ?> c) {
        QueryInterceptor i = (QueryInterceptor)TestingUtil.findInterceptor(c, QueryInterceptor.class);
        assert (i != null) : "Expected to find a QueryInterceptor, only found " + c.getAdvancedCache().getAsyncInterceptorChain().getInterceptors();
    }

    public void testModified() throws Exception {
        this.prepareTestData();
        this.assertQueryInterceptorPresent(this.cache2);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 1) : "Expected list of size 1, was of size " + found.size();
        assert (((Person)found.get(0)).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache1.put((Object)"Navin", (Object)this.person1);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("pizza");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        found = this.cacheQuery.list();
        assert (found.size() == 1);
        assert (((Person)found.get(0)).equals(this.person1));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testAdded() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        AssertJUnit.assertFalse((String)"This should not contain object person4", (boolean)found.contains(this.person4));
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache1.put((Object)"mighty", (Object)this.person4);
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        found = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        AssertJUnit.assertTrue((String)"This should now contain object person4", (boolean)found.contains(this.person4));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testRemoved() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 2);
        assert (found.contains(this.person2));
        assert (found.contains(this.person3)) : "This should still contain object person3";
        this.cache1.remove((Object)"MiniGoat");
        found = this.cacheQuery.list();
        assert (found.size() == 1);
        assert (found.contains(this.person2));
        assert (!found.contains(this.person3)) : "This should not contain object person3 anymore";
        assert (this.countIndex(this.cache1) == 2) : "Two documents should remain in the index";
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    protected int queryIndex(Cache<?, ?> cache, String query) throws ParseException {
        QueryParser qp = TestQueryHelperFactory.createQueryParser("blurb");
        Query q = qp.parse(query);
        HSQuery hsQuery = ((SearchIntegrator)Search.getSearchManager(cache).unwrap(SearchIntegrator.class)).createHSQuery(q, new Class[]{Person.class});
        return hsQuery.queryResultSize();
    }

    protected int countIndex(Cache<?, ?> cache) throws ParseException {
        return this.queryIndex(cache, "*:*");
    }

    private Optional<Cache<Object, Person>> findCache(Ownership ownership, Object key) {
        List caches = this.caches();
        ClusteringDependentLogic cdl = (ClusteringDependentLogic)this.cache1.getAdvancedCache().getComponentRegistry().getComponent(ClusteringDependentLogic.class);
        DistributionInfo distribution = cdl.getCacheTopology().getDistribution(key);
        Predicate<Cache> predicate = null;
        switch (ownership) {
            case PRIMARY: {
                predicate = c -> c.getAdvancedCache().getRpcManager().getAddress().equals(distribution.primary());
                break;
            }
            case BACKUP: {
                predicate = c -> distribution.writeBackups().contains(c.getAdvancedCache().getRpcManager().getAddress());
                break;
            }
            case NON_OWNER: {
                predicate = c -> !distribution.writeOwners().contains(c.getAdvancedCache().getRpcManager().getAddress());
            }
        }
        return caches.stream().filter(predicate).findFirst();
    }

    public void testConditionalRemoveFromPrimary() throws Exception {
        this.testConditionalRemoveFrom(Ownership.PRIMARY);
    }

    public void testConditionalRemoveFromBackup() throws Exception {
        this.testConditionalRemoveFrom(Ownership.BACKUP);
    }

    public void testConditionalRemoveFromNonOwner() throws Exception {
        this.testConditionalRemoveFrom(Ownership.NON_OWNER);
    }

    public void testConditionalReplaceFromPrimary() throws Exception {
        this.testConditionalReplaceFrom(Ownership.PRIMARY);
    }

    public void testConditionalReplaceFromBackup() throws Exception {
        this.testConditionalReplaceFrom(Ownership.BACKUP);
    }

    public void testConditionalReplaceFromNonOwner() throws Exception {
        this.testConditionalReplaceFrom(Ownership.NON_OWNER);
    }

    private <T> CacheQuery<T> createCacheQuery(String query) throws ParseException {
        this.queryParser = TestQueryHelperFactory.createQueryParser(query.substring(0, query.indexOf(58)));
        Query q = this.queryParser.parse(query);
        return Search.getSearchManager(this.cache1).getQuery(q, new Class[0]);
    }

    private void testConditionalReplaceFrom(Ownership memberType) throws Exception {
        this.prepareTestData();
        Cache<Object, Person> cache = this.findCache(memberType, "Navin").orElse(this.cache2);
        AssertJUnit.assertEquals((int)this.createCacheQuery("blurb:wow").list().size(), (int)1);
        boolean replaced = cache.replace((Object)"Navin", (Object)this.person1, (Object)this.person2);
        AssertJUnit.assertTrue((boolean)replaced);
        AssertJUnit.assertEquals((int)this.createCacheQuery("blurb:wow").list().size(), (int)0);
        AssertJUnit.assertEquals((int)this.queryIndex(cache, "blurb:wow"), (int)0);
    }

    private void testConditionalRemoveFrom(Ownership owneship) throws Exception {
        this.prepareTestData();
        CacheQuery query = Search.getSearchManager(this.cache2).getQuery((Query)new MatchAllDocsQuery(), new Class[0]);
        Cache<Object, Person> cache = this.findCache(owneship, "Navin").orElse(this.cache2);
        cache.remove((Object)"Navin", (Object)this.person1);
        AssertJUnit.assertEquals((int)query.list().size(), (int)2);
        AssertJUnit.assertEquals((int)this.countIndex(cache), (int)2);
        cache.remove((Object)"Navin", (Object)this.person1);
        AssertJUnit.assertEquals((int)query.list().size(), (int)2);
        AssertJUnit.assertEquals((int)this.countIndex(cache), (int)2);
        cache = this.findCache(owneship, "MiniGoat").orElse(this.cache2);
        cache.remove((Object)"MiniGoat");
        AssertJUnit.assertEquals((int)query.list().size(), (int)1);
        AssertJUnit.assertEquals((int)this.countIndex(cache), (int)1);
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testGetResultSize() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testPutMap() throws Exception {
        this.prepareTestData();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        HashMap<String, Person> allWrites = new HashMap<String, Person>();
        allWrites.put("Navin", this.person1);
        allWrites.put("BigGoat", this.person2);
        allWrites.put("MiniGoat", this.person3);
        this.cache2.putAll(allWrites);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        this.cache2.putAll(allWrites);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testPutMapAsync() throws Exception {
        this.prepareTestData();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        assert (searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size() == 3);
        this.person4 = new Person();
        this.person4.setName("New Goat");
        this.person4.setBlurb("Also eats grass");
        HashMap<String, Person> allWrites = new HashMap<String, Person>();
        allWrites.put("Navin", this.person1);
        allWrites.put("BigGoat", this.person2);
        allWrites.put("MiniGoat", this.person3);
        allWrites.put("newGoat", this.person4);
        CompletableFuture futureTask = this.cache2.putAllAsync(allWrites);
        futureTask.get();
        assert (futureTask.isDone());
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        assert (found.contains(this.person4));
        futureTask = this.cache1.putAllAsync(allWrites);
        futureTask.get();
        assert (futureTask.isDone());
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        assert (found.contains(this.person4));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testPutForExternalRead() throws Exception {
        this.prepareTestData();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        this.person4 = new Person();
        this.person4.setName("New Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache2.putForExternalRead((Object)"newGoat", (Object)this.person4);
        this.eventually(() -> this.cache2.get((Object)"newGoat") != null);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        Person person5 = new Person();
        person5.setName("Abnormal Goat");
        person5.setBlurb("Plays with grass.");
        this.cache2.putForExternalRead((Object)"newGoat", (Object)person5);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(person5));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testPutIfAbsent() throws Exception {
        this.prepareTestData();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        assert (searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size() == 3);
        this.person4 = new Person();
        this.person4.setName("New Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache2.putIfAbsent((Object)"newGoat", (Object)this.person4);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        assert (found.contains(this.person4));
        Person person5 = new Person();
        person5.setName("Abnormal Goat");
        person5.setBlurb("Plays with grass.");
        this.cache2.putIfAbsent((Object)"newGoat", (Object)person5);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(person5));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testPutIfAbsentAsync() throws Exception {
        this.prepareTestData();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        this.person4 = new Person();
        this.person4.setName("New Goat");
        this.person4.setBlurb("Also eats grass");
        CompletableFuture futureTask = this.cache2.putIfAbsentAsync((Object)"newGoat", (Object)this.person4);
        futureTask.get();
        AssertJUnit.assertTrue((boolean)futureTask.isDone());
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        Person person5 = new Person();
        person5.setName("Abnormal Goat");
        person5.setBlurb("Plays with grass.");
        futureTask = this.cache2.putIfAbsentAsync((Object)"newGoat", (Object)person5);
        futureTask.get();
        AssertJUnit.assertTrue((boolean)futureTask.isDone());
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(person5));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testPutAsync() throws Exception {
        this.prepareTestData();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        this.person4 = new Person();
        this.person4.setName("New Goat");
        this.person4.setBlurb("Also eats grass");
        CompletableFuture f = this.cache2.putAsync((Object)"newGoat", (Object)this.person4);
        f.get();
        AssertJUnit.assertTrue((boolean)f.isDone());
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        Person person5 = new Person();
        person5.setName("Abnormal Goat");
        person5.setBlurb("Plays with grass.");
        f = this.cache2.putAsync((Object)"newGoat", (Object)person5);
        f.get();
        AssertJUnit.assertTrue((boolean)f.isDone());
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(this.person4));
        AssertJUnit.assertTrue((boolean)found.contains(person5));
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testClear() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        BooleanQuery luceneQuery = new BooleanQuery.Builder().add(this.queryParser.parse("eats"), BooleanClause.Occur.SHOULD).add(this.queryParser.parse("playing"), BooleanClause.Occur.SHOULD).build();
        CacheQuery cacheQuery1 = Search.getSearchManager(this.cache1).getQuery((Query)luceneQuery, new Class[0]);
        CacheQuery cacheQuery2 = Search.getSearchManager(this.cache2).getQuery((Query)luceneQuery, new Class[0]);
        AssertJUnit.assertEquals((int)3, (int)cacheQuery1.getResultSize());
        AssertJUnit.assertEquals((int)3, (int)cacheQuery2.getResultSize());
        this.cache2.clear();
        AssertJUnit.assertEquals((int)0, (int)cacheQuery1.list().size());
        AssertJUnit.assertEquals((int)0, (int)cacheQuery2.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testFullTextFilterOnOff() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("eats");
        CacheQuery query = Search.getSearchManager(this.cache1).getQuery(luceneQuery, new Class[0]);
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"cheese");
        AssertJUnit.assertEquals((int)1, (int)query.getResultSize());
        List result = query.list();
        Person person = (Person)result.get(0);
        AssertJUnit.assertEquals((String)"MiniGoat", (String)person.getName());
        AssertJUnit.assertEquals((String)"Eats cheese", (String)person.getBlurb());
        query.disableFullTextFilter("personFilter");
        AssertJUnit.assertEquals((int)2, (int)query.getResultSize());
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testCombinationOfFilters() throws Exception {
        this.prepareTestData();
        this.person4 = new Person();
        this.person4.setName("ExtraGoat");
        this.person4.setBlurb("Eats grass and is retired");
        this.person4.setAge(70);
        this.cache1.put((Object)"ExtraGoat", (Object)this.person4);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("eats");
        CacheQuery query = Search.getSearchManager(this.cache1).getQuery(luceneQuery, new Class[0]);
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"grass");
        AssertJUnit.assertEquals((int)2, (int)query.getResultSize());
        FullTextFilter ageFilter = query.enableFullTextFilter("personAgeFilter");
        ageFilter.setParameter("age", (Object)70);
        AssertJUnit.assertEquals((int)1, (int)query.getResultSize());
        List result = query.list();
        Person person = (Person)result.get(0);
        AssertJUnit.assertEquals((String)"ExtraGoat", (String)person.getName());
        AssertJUnit.assertEquals((int)70, (int)person.getAge());
        query.disableFullTextFilter("personFilter");
        query.disableFullTextFilter("personAgeFilter");
        AssertJUnit.assertEquals((int)3, (int)query.getResultSize());
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testSearchKeyTransformer() throws Exception {
        this.caches().forEach(cache -> {
            SearchManagerImplementor manager = (SearchManagerImplementor)Search.getSearchManager((Cache)cache).unwrap(SearchManagerImplementor.class);
            manager.registerKeyTransformer(CustomKey3.class, CustomKey3Transformer.class);
        });
        this.prepareTestedObjects();
        TransactionManager transactionManager = this.cache1.getAdvancedCache().getTransactionManager();
        CustomKey3 customKey1 = new CustomKey3("Navin");
        CustomKey3 customKey2 = new CustomKey3("BigGoat");
        CustomKey3 customKey3 = new CustomKey3("MiniGoat");
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache1.put((Object)customKey1, (Object)this.person1);
        this.cache1.put((Object)customKey2, (Object)this.person2);
        this.cache1.put((Object)customKey3, (Object)this.person3);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager(this.cache1).getQuery(luceneQuery, new Class[0]);
        int counter = 0;
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            while (found.hasNext()) {
                found.next();
                ++counter;
            }
        }
        AssertJUnit.assertEquals((int)2, (int)counter);
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
    }

    public void testCompute() throws Exception {
        this.prepareTestData();
        TransactionManager transactionManager = this.cache2.getAdvancedCache().getTransactionManager();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        String key = "newGoat";
        this.person4 = new Person(key, "eats something", 42);
        BiFunction remappingFunction = (BiFunction<String, Person, Person> & Serializable)(k, v) -> new Person((String)k, "eats something", 42);
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.compute((Object)key, remappingFunction);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        BiFunction remappingExisting = (BiFunction<String, Person, Person> & Serializable)(k, v) -> new Person((String)k, "eats other things", 42);
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.compute((Object)key, remappingExisting);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(this.person4));
        AssertJUnit.assertTrue((boolean)found.contains(new Person(key, "eats other things", 42)));
        BiFunction remappingToNull = (BiFunction<String, Person, Person> & Serializable)(k, v) -> null;
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.compute((Object)key, remappingToNull);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(this.person4));
        AssertJUnit.assertFalse((boolean)found.contains(new Person(key, "eats other things", 42)));
    }

    public void testComputeIfPresent() throws Exception {
        this.prepareTestData();
        TransactionManager transactionManager = this.cache2.getAdvancedCache().getTransactionManager();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        BiFunction remappingExisting = (BiFunction<String, Person, Person> & Serializable)(k, v) -> new Person("replaced", "personOneChanged", 42);
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.computeIfPresent((Object)"Navin", remappingExisting);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(this.person1));
        AssertJUnit.assertTrue((boolean)found.contains(new Person("replaced", "personOneChanged", 42)));
        String newKey = "newGoat";
        this.person4 = new Person(newKey, "eats something", 42);
        BiFunction remappingFunction = (BiFunction<String, Person, Person> & Serializable)(k, v) -> new Person((String)k, "eats something", 42);
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.computeIfPresent((Object)newKey, remappingFunction);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(this.person4));
        BiFunction remappingToNull = (BiFunction<String, Person, Person> & Serializable)(k, v) -> null;
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.computeIfPresent((Object)"BigGoat", remappingToNull);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertFalse((boolean)found.contains(this.person2));
    }

    public void testComputeIfAbsent() throws Exception {
        this.prepareTestData();
        TransactionManager transactionManager = this.cache2.getAdvancedCache().getTransactionManager();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        String key = "newGoat";
        this.person4 = new Person(key, "eats something", 42);
        Function mappingFunction = (Function<String, Person> & Serializable)k -> new Person((String)k, "eats something", 42);
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.computeIfAbsent((Object)key, mappingFunction);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.computeIfAbsent((Object)"Navin", mappingFunction);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(new Person("Navin", "eats something", 42)));
        AssertJUnit.assertTrue((boolean)found.contains(this.person1));
        Function mappingToNull = (Function<String, Person> & Serializable)k -> null;
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.computeIfAbsent((Object)"anotherKey", mappingToNull);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(null));
    }

    public void testMerge() throws Exception {
        this.prepareTestData();
        TransactionManager transactionManager = this.cache2.getAdvancedCache().getTransactionManager();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        AssertJUnit.assertEquals((int)3, (int)searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size());
        String key = "newGoat";
        this.person4 = new Person(key, "eats something", 42);
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.merge((Object)key, (Object)this.person4, (SerializableBiFunction & Serializable)(k1, v3) -> new Person(key, "eats something", 42));
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.merge((Object)key, (Object)new Person(key, "hola", 42), (SerializableBiFunction & Serializable)(v1, v2) -> new Person(v1.getName() + "_" + v2.getName(), v1.getBlurb() + "_" + v2.getBlurb(), v1.getAge() + v2.getAge()));
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(this.person4));
        AssertJUnit.assertTrue((boolean)found.contains(new Person("newGoat_newGoat", "eats something_hola", 84)));
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache2.merge((Object)key, (Object)this.person4, (SerializableBiFunction & Serializable)(k, v) -> null);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertFalse((boolean)found.contains(this.person4));
        AssertJUnit.assertFalse((boolean)found.contains(new Person("newGoat_newGoat", "eats something_hola", 84)));
    }
}

